/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.eco.builder.heron;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import org.apache.heron.api.bolt.IBasicBolt;
import org.apache.heron.api.bolt.IRichBolt;
import org.apache.heron.api.bolt.IStatefulWindowedBolt;
import org.apache.heron.api.bolt.IWindowedBolt;
import org.apache.heron.api.grouping.CustomStreamGrouping;
import org.apache.heron.api.topology.BoltDeclarer;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.api.tuple.Fields;
import org.apache.heron.eco.builder.ObjectBuilder;
import org.apache.heron.eco.definition.ComponentStream;
import org.apache.heron.eco.definition.EcoExecutionContext;
import org.apache.heron.eco.definition.EcoTopologyDefinition;
import org.apache.heron.eco.definition.GroupingDefinition;
import org.apache.heron.eco.definition.ObjectDefinition;
import org.apache.heron.eco.definition.StreamDefinition;

public class StreamBuilder {
    protected <K extends Serializable, V extends Serializable> void buildStreams(EcoExecutionContext executionContext, TopologyBuilder builder, ObjectBuilder objectBuilder) throws IllegalAccessException, InstantiationException, ClassNotFoundException, NoSuchFieldException, InvocationTargetException {
        EcoTopologyDefinition topologyDefinition = executionContext.getTopologyDefinition();
        HashMap<String, ComponentStream> componentStreams = new HashMap<String, ComponentStream>();
        HashMap<String, BoltDeclarer> declarers = new HashMap<String, BoltDeclarer>();
        block8: for (StreamDefinition stream : topologyDefinition.getStreams()) {
            GroupingDefinition grouping;
            Object boltObj = executionContext.getBolt(stream.getTo());
            BoltDeclarer declarer = (BoltDeclarer)declarers.get(stream.getTo());
            if (boltObj instanceof IRichBolt) {
                if (declarer == null) {
                    declarer = builder.setBolt(stream.getTo(), (IRichBolt)boltObj, topologyDefinition.parallelismForBolt(stream.getTo()));
                    declarers.put(stream.getTo(), declarer);
                }
            } else if (boltObj instanceof IBasicBolt) {
                if (declarer == null) {
                    declarer = builder.setBolt(stream.getTo(), (IBasicBolt)boltObj, topologyDefinition.parallelismForBolt(stream.getTo()));
                    declarers.put(stream.getTo(), declarer);
                }
            } else if (boltObj instanceof IStatefulWindowedBolt) {
                if (declarer == null) {
                    declarer = builder.setBolt(stream.getTo(), (IStatefulWindowedBolt)boltObj, topologyDefinition.parallelismForBolt(stream.getTo()));
                    declarers.put(stream.getTo(), declarer);
                }
            } else if (boltObj instanceof IWindowedBolt) {
                if (declarer == null) {
                    declarer = builder.setBolt(stream.getTo(), (IWindowedBolt)boltObj, topologyDefinition.parallelismForBolt(stream.getTo()));
                    declarers.put(stream.getTo(), declarer);
                }
            } else {
                throw new IllegalArgumentException("Class does not appear to be a bolt: " + boltObj.getClass().getName());
            }
            String streamId = (grouping = stream.getGrouping()).getStreamId() == null ? "default" : grouping.getStreamId();
            switch (grouping.getType()) {
                case SHUFFLE: {
                    declarer.shuffleGrouping(stream.getFrom(), streamId);
                    continue block8;
                }
                case FIELDS: {
                    List<String> groupingArgs = grouping.getArgs();
                    if (groupingArgs == null) {
                        throw new IllegalArgumentException("You must supply arguments for Fields grouping");
                    }
                    declarer.fieldsGrouping(stream.getFrom(), streamId, new Fields(groupingArgs));
                    continue block8;
                }
                case ALL: {
                    declarer.allGrouping(stream.getFrom(), streamId);
                    continue block8;
                }
                case GLOBAL: {
                    declarer.globalGrouping(stream.getFrom(), streamId);
                    continue block8;
                }
                case NONE: {
                    declarer.noneGrouping(stream.getFrom(), streamId);
                    continue block8;
                }
                case CUSTOM: {
                    declarer.customGrouping(stream.getFrom(), streamId, this.buildCustomStreamGrouping(stream.getGrouping().getCustomClass(), executionContext, objectBuilder));
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("unsupported grouping type: " + grouping);
        }
        executionContext.setStreams(componentStreams);
    }

    private CustomStreamGrouping buildCustomStreamGrouping(ObjectDefinition objectDefinition, EcoExecutionContext executionContext, ObjectBuilder objectBuilder) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchFieldException, InvocationTargetException {
        Object grouping = objectBuilder.buildObject(objectDefinition, executionContext);
        return (CustomStreamGrouping)grouping;
    }
}

