/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.eco.builder;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.heron.eco.builder.BuilderUtility;
import org.apache.heron.eco.definition.ConfigurationMethodDefinition;
import org.apache.heron.eco.definition.EcoExecutionContext;
import org.apache.heron.eco.definition.ObjectDefinition;
import org.apache.heron.shaded.org.slf4j.Logger;
import org.apache.heron.shaded.org.slf4j.LoggerFactory;

public class ObjectBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectBuilder.class);
    private BuilderUtility builderUtility;

    public void setBuilderUtility(BuilderUtility builderUtility) {
        this.builderUtility = builderUtility;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object buildObject(ObjectDefinition def, EcoExecutionContext context) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchFieldException {
        void var4_8;
        Class<?> clazz = this.builderUtility.classForName(def.getClassName());
        if (def.hasConstructorArgs()) {
            LOG.debug("Found constructor arguments in definition ");
            List<Object> cArgs = def.getConstructorArgs();
            if (def.hasReferences()) {
                LOG.debug("The definition has references");
                cArgs = this.builderUtility.resolveReferences(cArgs, context);
            } else {
                LOG.debug("The definition does not have references");
            }
            LOG.debug("finding compatible constructor for : " + clazz.getName());
            Constructor con = this.findCompatibleConstructor(cArgs, clazz);
            if (con == null) {
                String msg = String.format("Couldn't find a suitable constructor for class '%s' with arguments '%s'.", clazz.getName(), cArgs);
                throw new IllegalArgumentException(msg);
            }
            LOG.debug("Found something seemingly compatible, attempting invocation...");
            Object t = con.newInstance(this.getArgsWithListCoercian(cArgs, con.getParameterTypes()));
        } else {
            Object obj = clazz.newInstance();
        }
        this.builderUtility.applyProperties(def, var4_8, context);
        this.invokeConfigMethods(def, var4_8, context);
        return var4_8;
    }

    protected Constructor findCompatibleConstructor(List<Object> args, Class target) {
        Constructor<?>[] cons;
        Constructor<?> retval = null;
        int eligibleCount = 0;
        LOG.debug("Target class: " + target.getName() + ", constructor args: " + args);
        for (Constructor<?> con : cons = target.getDeclaredConstructors()) {
            Class<?>[] paramClasses = con.getParameterTypes();
            if (paramClasses.length == args.size()) {
                LOG.debug("found constructor with same number of args..");
                boolean invokable = this.canInvokeWithArgs(args, con.getParameterTypes());
                if (invokable) {
                    retval = con;
                    ++eligibleCount;
                }
                LOG.debug("** invokable --> {}" + invokable);
                continue;
            }
            LOG.debug("Skipping constructor with wrong number of arguments.");
        }
        if (eligibleCount > 1) {
            LOG.error("Found multiple invokable constructors for class: " + target + ", given arguments " + args + ". Using the last one found.");
        }
        return retval;
    }

    protected boolean canInvokeWithArgs(List<Object> args, Class[] parameterTypes) {
        if (parameterTypes.length != args.size()) {
            LOG.warn("parameter types were the wrong size");
            return false;
        }
        for (int i = 0; i < args.size(); ++i) {
            Object obj = args.get(i);
            if (obj == null) {
                throw new IllegalArgumentException("argument shouldn't be null - index: " + i);
            }
            Class paramType = parameterTypes[i];
            Class<?> objectType = obj.getClass();
            LOG.debug("Comparing parameter class " + paramType + " to object class " + objectType + "to see if assignment is possible.");
            if (paramType.equals(objectType)) {
                LOG.debug("Yes, they are the same class.");
                continue;
            }
            if (paramType.isAssignableFrom(objectType)) {
                LOG.debug("Yes, assignment is possible.");
                continue;
            }
            if (this.isPrimitiveBoolean(paramType) && Boolean.class.isAssignableFrom(objectType)) {
                LOG.debug("Yes, assignment is possible.");
                continue;
            }
            if (this.isPrimitiveNumber(paramType) && Number.class.isAssignableFrom(objectType)) {
                LOG.debug("Yes, assignment is possible.");
                continue;
            }
            if (paramType.isEnum() && objectType.equals(String.class)) {
                LOG.debug("Yes, will convert a String to enum");
                continue;
            }
            if (paramType.isArray() && List.class.isAssignableFrom(objectType)) {
                LOG.debug("Assignment is possible if we convert a List to an array.");
                LOG.debug("Array Type: " + paramType.getComponentType() + ", List type: " + ((List)obj).get(0).getClass());
                continue;
            }
            LOG.debug("returning false");
            return false;
        }
        return true;
    }

    protected boolean isPrimitiveNumber(Class clazz) {
        return clazz.isPrimitive() && !clazz.equals(Boolean.TYPE);
    }

    protected boolean isPrimitiveBoolean(Class clazz) {
        return clazz.isPrimitive() && clazz.equals(Boolean.TYPE);
    }

    public void invokeConfigMethods(ObjectDefinition bean, Object instance, EcoExecutionContext context) throws InvocationTargetException, IllegalAccessException {
        List<ConfigurationMethodDefinition> methodDefs = bean.getConfigMethods();
        if (methodDefs == null || methodDefs.size() == 0) {
            return;
        }
        Class<?> clazz = instance.getClass();
        for (ConfigurationMethodDefinition methodDef : methodDefs) {
            List<Object> args = methodDef.getArgs();
            if (args == null) {
                args = new ArrayList<Object>();
            }
            if (methodDef.hasReferences()) {
                args = this.builderUtility.resolveReferences(args, context);
            }
            String methodName = methodDef.getName();
            LOG.debug("method name: " + methodName);
            Method method = this.findCompatibleMethod(args, clazz, methodName);
            if (method != null) {
                Object[] methodArgs = this.getArgsWithListCoercian(args, method.getParameterTypes());
                method.invoke(instance, methodArgs);
                continue;
            }
            String msg = String.format("Unable to find configuration method '%s' in class '%s' with arguments %s.", methodName, clazz.getName(), args);
            throw new IllegalArgumentException(msg);
        }
    }

    private Method findCompatibleMethod(List<Object> args, Class target, String methodName) {
        Method retval = null;
        int eligibleCount = 0;
        LOG.debug("Target class: " + target.getName() + ",  methodName: " + methodName + ", args: " + args);
        Method[] methods = target.getMethods();
        LOG.debug("methods count: " + methods.length);
        for (Method method : methods) {
            Class<?>[] paramClasses = method.getParameterTypes();
            if (paramClasses.length == args.size() && method.getName().equals(methodName)) {
                LOG.debug("found constructor with same number of args..");
                boolean invokable = false;
                invokable = args.size() == 0 ? true : this.canInvokeWithArgs(args, method.getParameterTypes());
                if (invokable) {
                    retval = method;
                    ++eligibleCount;
                }
                LOG.debug("** invokable --> " + invokable);
                continue;
            }
            LOG.debug("Skipping method with wrong number of arguments.");
        }
        if (eligibleCount > 1) {
            LOG.warn("Found multiple invokable methods for class, method, given arguments {} " + Arrays.toString(new Object[]{target, methodName, args}));
        }
        return retval;
    }

    private Object[] getArgsWithListCoercian(List<Object> args, Class[] parameterTypes) {
        if (parameterTypes.length != args.size()) {
            throw new IllegalArgumentException("Contructor parameter count does not egual argument size.");
        }
        Object[] constructorParams = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            Object obj = args.get(i);
            Class paramType = parameterTypes[i];
            Class<?> objectType = obj.getClass();
            LOG.debug("Comparing parameter class " + paramType.getName() + " to object class " + objectType.getName() + " to see if assignment is possible.");
            if (paramType.equals(objectType)) {
                LOG.debug("They are the same class.");
                constructorParams[i] = args.get(i);
                continue;
            }
            if (paramType.isAssignableFrom(objectType)) {
                LOG.debug("Assignment is possible.");
                constructorParams[i] = args.get(i);
                continue;
            }
            if (this.isPrimitiveBoolean(paramType) && Boolean.class.isAssignableFrom(objectType)) {
                LOG.debug("Its a primitive boolean.");
                Boolean bool = (Boolean)args.get(i);
                constructorParams[i] = (boolean)bool;
                continue;
            }
            if (this.isPrimitiveNumber(paramType) && Number.class.isAssignableFrom(objectType)) {
                LOG.debug("Its a primitive number.");
                Number num = (Number)args.get(i);
                if (paramType == Float.TYPE) {
                    constructorParams[i] = Float.valueOf(num.floatValue());
                    continue;
                }
                if (paramType == Double.TYPE) {
                    constructorParams[i] = num.doubleValue();
                    continue;
                }
                if (paramType == Long.TYPE) {
                    constructorParams[i] = num.longValue();
                    continue;
                }
                if (paramType == Integer.TYPE) {
                    constructorParams[i] = num.intValue();
                    continue;
                }
                if (paramType == Short.TYPE) {
                    constructorParams[i] = num.shortValue();
                    continue;
                }
                if (paramType == Byte.TYPE) {
                    constructorParams[i] = num.byteValue();
                    continue;
                }
                constructorParams[i] = args.get(i);
                continue;
            }
            if (paramType.isEnum() && objectType.equals(String.class)) {
                LOG.debug("Yes, will convert a String to enum");
                constructorParams[i] = Enum.valueOf(paramType, (String)args.get(i));
                continue;
            }
            if (!paramType.isArray() || !List.class.isAssignableFrom(objectType)) continue;
            LOG.debug("Conversion appears possible...");
            List list = (List)obj;
            LOG.debug("Array Type: {}, List type: {}" + paramType.getComponentType() + list.get(0).getClass());
            Object newArrayObj = Array.newInstance(paramType.getComponentType(), list.size());
            for (int j = 0; j < list.size(); ++j) {
                Array.set(newArrayObj, j, list.get(j));
            }
            constructorParams[i] = newArrayObj;
            LOG.debug("After conversion: {}" + constructorParams[i]);
        }
        return constructorParams;
    }
}

