/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.eco.builder;

import java.util.List;
import java.util.Map;
import org.apache.heron.api.Config;
import org.apache.heron.common.basics.ByteAmount;
import org.apache.heron.eco.definition.EcoTopologyDefinition;

public class ConfigBuilder {
    public static final String COMPONENT_RESOURCE_MAP = "topology.component.resourcemap";
    public static final String COMPONENT_JVM_OPTIONS = "topology.component.jvmoptions";
    private static final String ID = "id";
    private static final String RAM = "ram";
    private static final String CPU = "cpu";
    private static final String DISK = "disk";
    private static final String OPTIONS = "options";
    private static final String EQUALS = "=";
    private static final String WHITESPACE = " ";
    private static final String COMMA = ",";
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String MB = "MB";
    private static final String GB = "GB";
    private static final String B = "B";
    private static final Integer MINIMUM_BYTES = 256000000;
    private static final Integer MINIMUM_MB = 256;

    public Config buildConfig(EcoTopologyDefinition topologyDefinition) throws IllegalArgumentException {
        Map<String, Object> configMap = topologyDefinition.getConfig();
        Config config = new Config();
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            if (entry.getKey().equals(COMPONENT_RESOURCE_MAP)) {
                this.setComponentLevelResource(config, entry);
                continue;
            }
            if (entry.getKey().equals(COMPONENT_JVM_OPTIONS)) {
                List objects = (List)entry.getValue();
                for (Object obj : objects) {
                    String objString = obj.toString();
                    objString = objString.replace(LEFT_BRACE, WHITESPACE);
                    objString = objString.replace(RIGHT_BRACE, WHITESPACE);
                    int idIndex = objString.indexOf(ID);
                    int optionsIndex = objString.indexOf(OPTIONS);
                    String id = this.getIdValue(objString, idIndex);
                    if (optionsIndex == -1) {
                        throw new IllegalArgumentException("You must specify the JVM options for your component");
                    }
                    int equalsIndex = objString.indexOf(EQUALS, optionsIndex);
                    String jvmOptions = objString.substring(equalsIndex + 1, objString.length());
                    jvmOptions = jvmOptions.replace(LEFT_BRACKET, "").replace(RIGHT_BRACKET, "");
                    config.setComponentJvmOptions(id, jvmOptions);
                }
                continue;
            }
            config.put(entry.getKey(), entry.getValue());
        }
        return config;
    }

    private void setComponentLevelResource(Config config, Map.Entry<String, Object> entry) {
        List objects = (List)entry.getValue();
        for (Object obj : objects) {
            String objString = obj.toString();
            objString = objString.replace(COMMA, WHITESPACE);
            objString = objString.replace(LEFT_BRACE, WHITESPACE);
            objString = objString.replace(RIGHT_BRACE, WHITESPACE);
            int idIndex = objString.indexOf(ID);
            int ramIndex = objString.indexOf(RAM);
            int cpuIndex = objString.indexOf(CPU);
            int diskIndex = objString.indexOf(DISK);
            String ramWithUom = "";
            String id = this.getIdValue(objString, idIndex);
            String diskWithUom = "";
            String cpu = "";
            if (ramIndex != -1) {
                ramWithUom = this.assignValue(objString, ramIndex);
            }
            if (cpuIndex != -1) {
                cpu = this.assignValue(objString, cpuIndex);
            }
            if (diskIndex != -1) {
                diskWithUom = this.assignValue(objString, diskIndex);
            }
            ByteAmount byteAmount = null;
            if (ramWithUom.contains(MB)) {
                int mbIndex = this.verifyStartingIndexOfUom(ramWithUom, MB);
                long megaBytes = this.extractRawValue(ramWithUom, mbIndex);
                if (megaBytes < (long)MINIMUM_MB.intValue()) {
                    throw new IllegalArgumentException("The minimum RAM resource allocation for a component must be at least 256MB");
                }
                byteAmount = ByteAmount.fromMegabytes(megaBytes);
            } else if (ramWithUom.contains(GB)) {
                int gbIndex = this.verifyStartingIndexOfUom(ramWithUom, GB);
                byteAmount = ByteAmount.fromGigabytes(this.extractRawValue(ramWithUom, gbIndex));
            } else if (ramWithUom.contains(B)) {
                int bIndex = this.verifyStartingIndexOfUom(ramWithUom, B);
                long bytes = this.extractRawValue(ramWithUom, bIndex);
                if (bytes < (long)MINIMUM_BYTES.intValue()) {
                    throw new IllegalArgumentException("The minimum RAM resource allocation for a component must be at least 256000000B");
                }
                byteAmount = ByteAmount.fromBytes(bytes);
            } else {
                throw new IllegalArgumentException(" Please specify 'B', 'MB', 'GB' when declaring RAM Resources");
            }
            config.setComponentRam(id, byteAmount);
        }
    }

    private String getIdValue(String objString, int idIndex) {
        String id = "";
        if (idIndex == -1) {
            throw new IllegalArgumentException("Must specify ID of component to allocate resources");
        }
        id = this.assignValue(objString, idIndex);
        return id;
    }

    private int verifyStartingIndexOfUom(String ramWithUom, String uom) {
        int bIndex = ramWithUom.indexOf(uom);
        String ramUom = ramWithUom.substring(bIndex, ramWithUom.length());
        if (!ramUom.equalsIgnoreCase(uom)) {
            throw new IllegalArgumentException("Unit of Measure must be at the appended at the end of the value.");
        }
        return bIndex;
    }

    private long extractRawValue(String ramWithUom, int index) {
        return Long.valueOf(ramWithUom.substring(0, index));
    }

    private String assignValue(String objString, int index) {
        int equalsIndex = objString.indexOf(EQUALS, index);
        int spaceIndex = objString.indexOf(WHITESPACE, index);
        return objString.substring(equalsIndex + 1, spaceIndex);
    }
}

