/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.eco.builder;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.heron.eco.definition.BeanListReference;
import org.apache.heron.eco.definition.BeanReference;
import org.apache.heron.eco.definition.EcoExecutionContext;
import org.apache.heron.eco.definition.ObjectDefinition;
import org.apache.heron.eco.definition.PropertyDefinition;
import org.apache.heron.shaded.org.slf4j.Logger;
import org.apache.heron.shaded.org.slf4j.LoggerFactory;

public class BuilderUtility {
    private static final Logger LOG = LoggerFactory.getLogger(BuilderUtility.class);

    protected List<Object> resolveReferences(List<Object> args, EcoExecutionContext context) {
        LOG.debug("Checking arguments for references.");
        ArrayList<Object> cArgs = new ArrayList<Object>();
        for (Object arg : args) {
            if (arg instanceof BeanReference) {
                LOG.debug("BeanReference: " + ((BeanReference)arg).getId());
                cArgs.add(context.getComponent(((BeanReference)arg).getId()));
                continue;
            }
            if (arg instanceof BeanListReference) {
                ArrayList<Object> components = new ArrayList<Object>();
                BeanListReference ref = (BeanListReference)arg;
                for (String id : ref.getIds()) {
                    components.add(context.getComponent(id));
                }
                LOG.debug("BeanListReference resolved as {}" + components);
                cArgs.add(components);
                continue;
            }
            LOG.debug("Unknown:" + arg.toString());
            cArgs.add(arg);
        }
        return cArgs;
    }

    protected void applyProperties(ObjectDefinition bean, Object instance, EcoExecutionContext context) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        List<PropertyDefinition> props = bean.getProperties();
        Class<?> clazz = instance.getClass();
        if (props != null) {
            for (PropertyDefinition prop : props) {
                Object value = prop.isReference() ? context.getComponent(prop.getRef()) : prop.getValue();
                Method setter = this.findSetter(clazz, prop.getName());
                if (setter != null) {
                    LOG.debug("found setter, attempting with: " + instance.getClass() + "  " + value);
                    setter.invoke(instance, value);
                    continue;
                }
                LOG.debug("no setter found. Looking for a public instance variable...");
                Field field = this.findPublicField(clazz, prop.getName());
                if (field == null) continue;
                field.set(instance, value);
            }
        }
    }

    protected Field findPublicField(Class clazz, String property) throws NoSuchFieldException {
        Field field = clazz.getField(property);
        return field;
    }

    private Method findSetter(Class clazz, String property) {
        Method[] methods;
        String setterName = this.toSetterName(property);
        Method retval = null;
        for (Method method : methods = clazz.getMethods()) {
            if (!setterName.equals(method.getName())) continue;
            LOG.debug("Found setter method: " + method.getName());
            retval = method;
        }
        return retval;
    }

    protected String toSetterName(String name) {
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    protected Class<?> classForName(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }
}

