/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.topology;

import java.util.HashMap;
import java.util.Map;
import org.apache.heron.api.Config;
import org.apache.heron.api.HeronTopology;
import org.apache.heron.api.bolt.BaseBasicBolt;
import org.apache.heron.api.bolt.BasicOutputCollector;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.spout.BaseRichSpout;
import org.apache.heron.api.spout.SpoutOutputCollector;
import org.apache.heron.api.topology.BoltDeclarer;
import org.apache.heron.api.topology.OutputFieldsDeclarer;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Fields;
import org.apache.heron.api.tuple.Tuple;

public final class TopologyTests {
    private TopologyTests() {
    }

    public static TopologyAPI.Topology createTopologyWithConnection(String topologyName, Config heronConfig, Map<String, Integer> spouts, Map<String, Integer> bolts, Map<String, String> connections) {
        TopologyBuilder builder = new TopologyBuilder();
        BaseRichSpout baseSpout = new BaseRichSpout(){
            private static final long serialVersionUID = -719523487475322625L;

            @Override
            public void declareOutputFields(OutputFieldsDeclarer declarer) {
                declarer.declare(new Fields("field1"));
            }

            @Override
            public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
            }

            @Override
            public void nextTuple() {
            }
        };
        BaseBasicBolt basicBolt = new BaseBasicBolt(){
            private static final long serialVersionUID = 2544765902130713628L;

            @Override
            public void execute(Tuple input, BasicOutputCollector collector) {
            }

            @Override
            public void declareOutputFields(OutputFieldsDeclarer declarer) {
            }
        };
        for (String spout : spouts.keySet()) {
            builder.setSpout(spout, baseSpout, spouts.get(spout));
        }
        for (String bolt : bolts.keySet()) {
            BoltDeclarer boltDeclarer = builder.setBolt(bolt, basicBolt, (Number)bolts.get(bolt));
            if (!connections.containsKey(bolt)) continue;
            boltDeclarer.shuffleGrouping(connections.get(bolt));
        }
        HeronTopology heronTopology = builder.createTopology();
        return heronTopology.setName(topologyName).setConfig(heronConfig).setState(TopologyAPI.TopologyState.RUNNING).getTopology();
    }

    public static TopologyAPI.Topology createTopology(String topologyName, Config heronConfig, Map<String, Integer> spouts, Map<String, Integer> bolts) {
        return TopologyTests.createTopologyWithConnection(topologyName, heronConfig, spouts, bolts, new HashMap<String, String>());
    }

    public static TopologyAPI.Topology createTopology(String topologyName, Config topologyConfig, String spoutName, String boltName, int spoutParallelism, int boltParallelism) {
        HashMap<String, Integer> spouts = new HashMap<String, Integer>();
        spouts.put(spoutName, spoutParallelism);
        HashMap<String, Integer> bolts = new HashMap<String, Integer>();
        bolts.put(boltName, boltParallelism);
        return TopologyTests.createTopology(topologyName, topologyConfig, spouts, bolts);
    }
}

