/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.basics;

import org.apache.heron.common.basics.ResourceMeasure;

public final class ByteAmount
extends ResourceMeasure<Long> {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long MAX_MB = Math.round(8.796093E12f);
    private static final long MAX_GB = Math.round(8.589935E9f);
    private static final long MAX_KB = Math.round(9.007199E15f);
    public static final ByteAmount ZERO = ByteAmount.fromBytes(0L);

    private ByteAmount(Long value) {
        super(value);
    }

    public static ByteAmount fromBytes(long bytes) {
        return new ByteAmount(bytes);
    }

    public static ByteAmount fromMegabytes(long megabytes) {
        if (megabytes >= MAX_MB) {
            return new ByteAmount(Long.MAX_VALUE);
        }
        return new ByteAmount(megabytes * 0x100000L);
    }

    public static ByteAmount fromGigabytes(long gigabytes) {
        if (gigabytes >= MAX_GB) {
            return new ByteAmount(Long.MAX_VALUE);
        }
        return new ByteAmount(gigabytes * 0x40000000L);
    }

    public long asBytes() {
        return (Long)super.getValue();
    }

    public long asMegabytes() {
        return Math.round(((Long)this.value).doubleValue() / 1048576.0);
    }

    public long asKilobytes() {
        return Math.round(((Long)this.value).doubleValue() / 1024.0);
    }

    public long asGigabytes() {
        return Math.round(((Long)this.value).doubleValue() / 1.073741824E9);
    }

    public ByteAmount minus(ResourceMeasure<Long> other) {
        this.checkArgument(Long.MIN_VALUE + (Long)other.value <= (Long)this.value, String.format("Subtracting %s from %s would overshoot Long.MIN_LONG", other, this));
        return ByteAmount.fromBytes((Long)this.value - (Long)other.value);
    }

    public ByteAmount plus(ResourceMeasure<Long> other) {
        this.checkArgument(Long.MAX_VALUE - (Long)this.value >= (Long)other.value, String.format("Adding %s to %s would exceed Long.MAX_LONG", other, this));
        return ByteAmount.fromBytes((Long)this.value + (Long)other.value);
    }

    public ByteAmount multiply(int factor) {
        this.checkArgument((Long)this.value <= Long.MAX_VALUE / (long)factor, String.format("Multiplying %s by %d would exceed Long.MAX_LONG", this, factor));
        return ByteAmount.fromBytes((Long)this.value * (long)factor);
    }

    public ByteAmount divide(int factor) {
        this.checkArgument(factor != 0, String.format("Can not divide %s by 0", this));
        return ByteAmount.fromBytes(Math.round(((Long)this.value).doubleValue() / (double)factor));
    }

    public ByteAmount increaseBy(int percentage) {
        this.checkArgument(percentage >= 0, String.format("Increasing by negative percent (%d) not supported", percentage));
        double factor = 1.0 + (double)percentage / 100.0;
        long max = Math.round(9.223372036854776E18 / factor);
        this.checkArgument((Long)this.value <= max, String.format("Increasing %s by %d percent would exceed Long.MAX_LONG", this, percentage));
        return ByteAmount.fromBytes(Math.round(((Long)this.value).doubleValue() * factor));
    }

    public ByteAmount max(ByteAmount other) {
        if (this.greaterThan(other)) {
            return this;
        }
        return other;
    }

    public String toString() {
        String str = this.asGigabytes() > 0L ? String.format("%.1f GB (%d bytes)", ((Long)this.value).doubleValue() / 1.073741824E9, this.value) : (this.asMegabytes() > 0L ? String.format("%.1f MB (%d bytes)", ((Long)this.value).doubleValue() / 1048576.0, this.value) : (this.asKilobytes() > 0L ? String.format("%.1f KB (%d bytes)", ((Long)this.value).doubleValue() / 1024.0, this.value) : this.value + " bytes"));
        return String.format("ByteAmount{%s}", str);
    }

    private void checkArgument(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

