/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.windowing.triggers;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.heron.api.windowing.DefaultEvictionContext;
import org.apache.heron.api.windowing.Event;
import org.apache.heron.api.windowing.triggers.AbstractBaseTriggerPolicy;

public class CountTriggerPolicy<T extends Serializable>
extends AbstractBaseTriggerPolicy<T, Integer> {
    private final int count;
    private final AtomicInteger currentCount;

    public CountTriggerPolicy(int count) {
        this.count = count;
        this.currentCount = new AtomicInteger();
    }

    @Override
    public void track(Event<T> event) {
        if (this.started.booleanValue() && !event.isWatermark() && this.currentCount.incrementAndGet() >= this.count) {
            this.evictionPolicy.setContext(new DefaultEvictionContext(System.currentTimeMillis()));
            this.handler.onTrigger();
        }
    }

    @Override
    public void reset() {
        this.currentCount.set(0);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Integer getState() {
        return this.currentCount.get();
    }

    @Override
    public void restoreState(Integer state) {
        this.currentCount.set(state);
    }

    public String toString() {
        return "CountTriggerPolicy{count=" + this.count + ", currentCount=" + this.currentCount + ", started=" + this.started + '}';
    }
}

