/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.utils;

import backtype.storm.hooks.ITaskHookDelegate;
import backtype.storm.utils.Utils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.heron.api.Config;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static Config translateConfig(Map stormConfig) {
        Config heronConfig = stormConfig != null ? new Config(stormConfig) : new Config();
        ConfigUtils.doSerializationTranslation(heronConfig);
        ConfigUtils.doStormTranslation(heronConfig);
        ConfigUtils.doTaskHooksTranslation(heronConfig);
        ConfigUtils.doTopologyLevelTranslation(heronConfig);
        return heronConfig;
    }

    public static Config translateComponentConfig(Map stormConfig) {
        Config heronConfig = stormConfig != null ? new Config(stormConfig) : new Config();
        ConfigUtils.doStormTranslation(heronConfig);
        return heronConfig;
    }

    private static void doSerializationTranslation(Config heronConfig) {
        if (heronConfig.containsKey("topology.fall.back.on.java.serialization") && heronConfig.get("topology.fall.back.on.java.serialization") instanceof Boolean && ((Boolean)heronConfig.get("topology.fall.back.on.java.serialization")).booleanValue()) {
            Config.setSerializationClassName(heronConfig, "org.apache.heron.api.serializer.JavaSerializer");
        } else {
            heronConfig.put("topology.fall.back.on.java.serialization", false);
            Config.setSerializationClassName(heronConfig, "backtype.storm.serialization.HeronPluggableSerializerDelegate");
            if (!heronConfig.containsKey("topology.kryo.factory")) {
                heronConfig.put("topology.kryo.factory", "backtype.storm.serialization.DefaultKryoFactory");
            } else if (!(heronConfig.get("topology.kryo.factory") instanceof String)) {
                throw new RuntimeException("topology.kryo.factory has to be set to a class name");
            }
            if (!heronConfig.containsKey("topology.skip.missing.kryo.registrations")) {
                heronConfig.put("topology.skip.missing.kryo.registrations", false);
            } else if (!(heronConfig.get("topology.skip.missing.kryo.registrations") instanceof Boolean)) {
                throw new RuntimeException("topology.skip.missing.kryo.registrations has to be boolean");
            }
        }
    }

    private static void doTaskHooksTranslation(Config heronConfig) {
        List<String> hooks = heronConfig.getAutoTaskHooks();
        if (hooks != null && !hooks.isEmpty()) {
            heronConfig.put("stormcompat.topology.auto.task.hooks", hooks);
            LinkedList<String> translationHooks = new LinkedList<String>();
            translationHooks.add(ITaskHookDelegate.class.getName());
            heronConfig.setAutoTaskHooks(translationHooks);
        }
    }

    private static void doStormTranslation(Config heronConfig) {
        if (heronConfig.containsKey("topology.enable.message.timeouts")) {
            heronConfig.put("topology.enable.message.timeouts", heronConfig.get("topology.enable.message.timeouts").toString());
        }
        if (heronConfig.containsKey("topology.workers")) {
            Integer nWorkers = Utils.getInt(heronConfig.get("topology.workers"));
            Config.setNumStmgrs(heronConfig, nWorkers);
        }
        if (heronConfig.containsKey("topology.message.timeout.secs")) {
            Integer nSecs = Utils.getInt(heronConfig.get("topology.message.timeout.secs"));
            Config.setMessageTimeoutSecs(heronConfig, nSecs);
        }
        if (heronConfig.containsKey("topology.max.spout.pending")) {
            Integer nPending = Utils.getInt(heronConfig.get("topology.max.spout.pending").toString());
            Config.setMaxSpoutPending(heronConfig, nPending);
        }
        if (heronConfig.containsKey("topology.tick.tuple.freq.secs")) {
            Integer tSecs = Utils.getInt(heronConfig.get("topology.tick.tuple.freq.secs").toString());
            Config.setTickTupleFrequency(heronConfig, tSecs);
        }
        if (heronConfig.containsKey("topology.debug")) {
            Boolean dBg = Boolean.parseBoolean(heronConfig.get("topology.debug").toString());
            Config.setDebug(heronConfig, dBg);
        }
    }

    private static void doTopologyLevelTranslation(Config heronConfig) {
        if (heronConfig.containsKey("topology.acker.executors")) {
            Integer nAckers = Utils.getInt(heronConfig.get("topology.acker.executors"));
            if (nAckers > 0) {
                Config.setTopologyReliabilityMode(heronConfig, Config.TopologyReliabilityMode.ATLEAST_ONCE);
            } else {
                Config.setTopologyReliabilityMode(heronConfig, Config.TopologyReliabilityMode.ATMOST_ONCE);
            }
        } else {
            Config.setTopologyReliabilityMode(heronConfig, Config.TopologyReliabilityMode.ATMOST_ONCE);
        }
    }
}

