/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.topology;

import backtype.storm.task.OutputCollectorImpl;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsGetter;
import backtype.storm.tuple.TupleImpl;
import backtype.storm.utils.ConfigUtils;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.heron.api.bolt.OutputCollector;
import org.apache.heron.api.topology.IUpdatable;
import org.apache.heron.api.topology.OutputFieldsDeclarer;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Tuple;

public class IRichBoltDelegate
implements org.apache.heron.api.bolt.IRichBolt,
IUpdatable {
    private static final Logger LOG = Logger.getLogger(IRichBoltDelegate.class.getName());
    private static final long serialVersionUID = -3717575342431064148L;
    private IRichBolt delegate;
    private backtype.storm.task.TopologyContext topologyContextImpl;
    private OutputCollectorImpl outputCollectorImpl;

    public IRichBoltDelegate(IRichBolt delegate) {
        this.delegate = delegate;
    }

    public void prepare(Map conf, TopologyContext context, OutputCollector collector) {
        this.topologyContextImpl = new backtype.storm.task.TopologyContext(context);
        this.outputCollectorImpl = new OutputCollectorImpl(collector);
        this.delegate.prepare(conf, this.topologyContextImpl, this.outputCollectorImpl);
    }

    @Override
    public void cleanup() {
        this.delegate.cleanup();
    }

    @Override
    public void execute(Tuple tuple) {
        TupleImpl impl = new TupleImpl(tuple);
        this.delegate.execute(impl);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        OutputFieldsGetter getter = new OutputFieldsGetter(declarer);
        this.delegate.declareOutputFields(getter);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        Map<String, Object> config = this.delegate.getComponentConfiguration();
        return ConfigUtils.translateComponentConfig(config);
    }

    @Override
    public void update(TopologyContext topologyContext) {
        if (this.delegate instanceof IUpdatable) {
            ((IUpdatable)((Object)this.delegate)).update(topologyContext);
        } else {
            LOG.warning(String.format("Update() event received but can not call update() on delegate because it does not implement %s: %s", IUpdatable.class.getName(), this.delegate));
        }
    }
}

