/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.topology;

import backtype.storm.task.OutputCollector;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.FailedException;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.ReportedFailedException;
import backtype.storm.tuple.Tuple;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.heron.api.topology.IUpdatable;
import org.apache.heron.api.topology.TopologyContext;

public class BasicBoltExecutor
implements IRichBolt,
IUpdatable {
    private static final Logger LOG = Logger.getLogger(BasicBoltExecutor.class.getName());
    private static final long serialVersionUID = 4359767045622072660L;
    private IBasicBolt delegate;
    private transient BasicOutputCollector collector;

    public BasicBoltExecutor(IBasicBolt bolt) {
        this.delegate = bolt;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.delegate.declareOutputFields(declarer);
    }

    @Override
    public void prepare(Map stormConf, backtype.storm.task.TopologyContext context, OutputCollector newCollector) {
        this.delegate.prepare(stormConf, context);
        this.collector = new BasicOutputCollector(newCollector);
    }

    @Override
    public void execute(Tuple input) {
        this.collector.setContext(input);
        try {
            this.delegate.execute(input, this.collector);
            this.collector.getOutputter().ack(input);
        }
        catch (FailedException e) {
            if (e instanceof ReportedFailedException) {
                this.collector.reportError(e);
            }
            this.collector.getOutputter().fail(input);
        }
    }

    @Override
    public void cleanup() {
        this.delegate.cleanup();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.delegate.getComponentConfiguration();
    }

    @Override
    public void update(TopologyContext topologyContext) {
        if (this.delegate instanceof IUpdatable) {
            ((IUpdatable)((Object)this.delegate)).update(topologyContext);
        } else {
            LOG.warning(String.format("Update() event received but can not call update() on delegate because it does not implement %s: %s", IUpdatable.class.getName(), this.delegate));
        }
    }
}

