/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.metric.api;

import backtype.storm.metric.api.IMetric;
import backtype.storm.metric.api.IReducer;
import backtype.storm.metric.api.ReducedMetric;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MultiReducedMetric
implements IMetric {
    private Map<String, ReducedMetric> value = new ConcurrentHashMap<String, ReducedMetric>();
    private IReducer reducer;

    public MultiReducedMetric(IReducer reducer) {
        this.reducer = reducer;
    }

    public ReducedMetric scope(String key) {
        ReducedMetric val = this.value.get(key);
        if (val == null) {
            val = new ReducedMetric(this.reducer);
            this.value.put(key, val);
        }
        return val;
    }

    @Override
    public Object getValueAndReset() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry<String, ReducedMetric> e : this.value.entrySet()) {
            Object val = e.getValue().getValueAndReset();
            if (val == null) continue;
            ret.put(e.getKey(), val);
        }
        return ret;
    }
}

