/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm.metric.api;

import backtype.storm.metric.api.IReducer;
import org.apache.heron.api.metric.MeanReducerState;

public class MeanReducer
implements IReducer<MeanReducerState> {
    @Override
    public MeanReducerState init() {
        return new MeanReducerState();
    }

    @Override
    public MeanReducerState reduce(MeanReducerState acc, Object input) {
        ++acc.count;
        if (input instanceof Double) {
            acc.sum += ((Double)input).doubleValue();
        } else if (input instanceof Long) {
            acc.sum += ((Long)input).doubleValue();
        } else if (input instanceof Integer) {
            acc.sum += ((Integer)input).doubleValue();
        } else {
            throw new RuntimeException("MeanReducer::reduce called with unsupported input type `" + input.getClass() + "`. Supported types are Double, Long, Integer.");
        }
        return acc;
    }

    @Override
    public Object extractResult(MeanReducerState acc) {
        if (acc.count > 0) {
            return new Double(acc.sum / (double)acc.count);
        }
        return null;
    }
}

