/*
 * Decompiled with CFR 0.152.
 */
package backtype.storm;

import backtype.storm.ILocalCluster;
import backtype.storm.generated.AlreadyAliveException;
import backtype.storm.generated.InvalidTopologyException;
import backtype.storm.generated.NotAliveException;
import backtype.storm.generated.StormTopology;
import backtype.storm.utils.ConfigUtils;
import java.util.Map;
import org.apache.heron.simulator.Simulator;

public class LocalCluster
implements ILocalCluster {
    private final Simulator simulator = new Simulator();
    private String topologyName;
    private Map conf;
    private StormTopology topology;

    public LocalCluster() {
        this.resetFields();
    }

    @Override
    public void submitTopology(String topoName, Map config, StormTopology stormTopology) throws AlreadyAliveException, InvalidTopologyException {
        this.assertNotAlive();
        this.topologyName = topoName;
        this.conf = config;
        this.topology = stormTopology;
        this.simulator.submitTopology(topoName, ConfigUtils.translateConfig(config), stormTopology.getStormTopology());
    }

    @Override
    public void killTopology(String topoName) throws NotAliveException {
        this.assertAlive(topoName);
        this.simulator.killTopology(topoName);
        this.resetFields();
    }

    @Override
    public void activate(String topoName) throws NotAliveException {
        this.assertAlive(topoName);
        this.simulator.activate(topoName);
    }

    @Override
    public void deactivate(String topoName) throws NotAliveException {
        this.assertAlive(topoName);
        this.simulator.deactivate(topoName);
    }

    @Override
    public void shutdown() {
        this.resetFields();
        this.simulator.shutdown();
    }

    @Override
    public String getTopologyConf(String topoName) {
        try {
            this.assertAlive(topoName);
            return this.topologyName;
        }
        catch (NotAliveException ex) {
            return null;
        }
    }

    @Override
    public StormTopology getTopology(String topoName) {
        try {
            this.assertAlive(topoName);
            return this.topology;
        }
        catch (NotAliveException ex) {
            return null;
        }
    }

    @Override
    public Map getState() {
        throw new RuntimeException("Heron does not support LocalCluster yet...");
    }

    private void resetFields() {
        this.topologyName = null;
        this.topology = null;
        this.conf = null;
    }

    private void assertAlive(String topoName) throws NotAliveException {
        if (this.topologyName == null || !this.topologyName.equals(topoName)) {
            throw new NotAliveException();
        }
    }

    private void assertNotAlive() throws AlreadyAliveException {
        if (this.topologyName != null) {
            throw new AlreadyAliveException();
        }
    }
}

