/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.KeyedWindow;
import org.apache.heron.streamlet.SerializableBinaryOperator;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.WindowConfig;
import org.apache.heron.streamlet.impl.StreamletBaseImpl;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.groupings.ReduceByKeyAndWindowCustomGrouping;
import org.apache.heron.streamlet.impl.operators.ReduceByKeyAndWindowOperator;

public class ReduceByKeyAndWindowStreamlet<R, K, T>
extends StreamletImpl<KeyValue<KeyedWindow<K>, T>> {
    private StreamletImpl<R> parent;
    private SerializableFunction<R, K> keyExtractor;
    private SerializableFunction<R, T> valueExtractor;
    private WindowConfig windowCfg;
    private SerializableBinaryOperator<T> reduceFn;

    public ReduceByKeyAndWindowStreamlet(StreamletImpl<R> parent, SerializableFunction<R, K> keyExtractor, SerializableFunction<R, T> valueExtractor, WindowConfig windowCfg, SerializableBinaryOperator<T> reduceFn) {
        this.parent = parent;
        this.keyExtractor = keyExtractor;
        this.valueExtractor = valueExtractor;
        this.windowCfg = windowCfg;
        this.reduceFn = reduceFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletBaseImpl.StreamletNamePrefix.REDUCE, stageNames);
        ReduceByKeyAndWindowOperator<R, K, T> bolt = new ReduceByKeyAndWindowOperator<R, K, T>(this.keyExtractor, this.valueExtractor, this.reduceFn);
        this.windowCfg.applyTo(bolt);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).customGrouping(this.parent.getName(), this.parent.getStreamId(), new ReduceByKeyAndWindowCustomGrouping<R, K>(this.keyExtractor));
        return true;
    }
}

