/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.heron.api.grouping.NoneStreamGrouping;
import org.apache.heron.api.grouping.StreamGrouping;
import org.apache.heron.streamlet.IStreamletOperator;
import org.apache.heron.streamlet.JoinType;
import org.apache.heron.streamlet.KVStreamlet;
import org.apache.heron.streamlet.KeyedWindow;
import org.apache.heron.streamlet.SerializableBiFunction;
import org.apache.heron.streamlet.SerializableBinaryOperator;
import org.apache.heron.streamlet.SerializableConsumer;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.SerializablePredicate;
import org.apache.heron.streamlet.SerializableTransformer;
import org.apache.heron.streamlet.Sink;
import org.apache.heron.streamlet.Streamlet;
import org.apache.heron.streamlet.StreamletBase;
import org.apache.heron.streamlet.WindowConfig;
import org.apache.heron.streamlet.impl.StreamletBaseImpl;
import org.apache.heron.streamlet.impl.streamlets.ConsumerStreamlet;
import org.apache.heron.streamlet.impl.streamlets.CountByKeyAndWindowStreamlet;
import org.apache.heron.streamlet.impl.streamlets.CountByKeyStreamlet;
import org.apache.heron.streamlet.impl.streamlets.CustomStreamlet;
import org.apache.heron.streamlet.impl.streamlets.FilterStreamlet;
import org.apache.heron.streamlet.impl.streamlets.FlatMapStreamlet;
import org.apache.heron.streamlet.impl.streamlets.GeneralReduceByKeyAndWindowStreamlet;
import org.apache.heron.streamlet.impl.streamlets.GeneralReduceByKeyStreamlet;
import org.apache.heron.streamlet.impl.streamlets.JoinStreamlet;
import org.apache.heron.streamlet.impl.streamlets.KVStreamletShadow;
import org.apache.heron.streamlet.impl.streamlets.KeyByStreamlet;
import org.apache.heron.streamlet.impl.streamlets.LogStreamlet;
import org.apache.heron.streamlet.impl.streamlets.MapStreamlet;
import org.apache.heron.streamlet.impl.streamlets.ReduceByKeyAndWindowStreamlet;
import org.apache.heron.streamlet.impl.streamlets.ReduceByKeyStreamlet;
import org.apache.heron.streamlet.impl.streamlets.RemapStreamlet;
import org.apache.heron.streamlet.impl.streamlets.SinkStreamlet;
import org.apache.heron.streamlet.impl.streamlets.SplitStreamlet;
import org.apache.heron.streamlet.impl.streamlets.StreamletShadow;
import org.apache.heron.streamlet.impl.streamlets.TransformStreamlet;
import org.apache.heron.streamlet.impl.streamlets.UnionStreamlet;
import org.apache.heron.streamlet.impl.utils.StreamletUtils;

public abstract class StreamletImpl<R>
extends StreamletBaseImpl<R>
implements Streamlet<R> {
    private static final Logger LOG = Logger.getLogger(StreamletImpl.class.getName());

    @Override
    public Streamlet<R> setName(String sName) {
        super.setName(sName);
        return this;
    }

    @Override
    public Streamlet<R> setNumPartitions(int numPartitions) {
        super.setNumPartitions(numPartitions);
        return this;
    }

    @Override
    public Streamlet<R> withStream(final String streamId) {
        StreamletUtils.checkNotBlank(streamId, "streamId can't be empty");
        Set<String> availableIds = this.getAvailableStreamIds();
        if (availableIds.contains(streamId)) {
            return new StreamletShadow<R>(this){

                @Override
                public String getStreamId() {
                    return streamId;
                }
            };
        }
        throw new RuntimeException(String.format("Stream id %s is not available in %s. Available ids are: %s.", streamId, this.getName(), availableIds.toString()));
    }

    protected Set<String> getAvailableStreamIds() {
        HashSet<String> ids = new HashSet<String>();
        ids.add(this.getStreamId());
        return ids;
    }

    @Override
    public String getStreamId() {
        return "default";
    }

    protected StreamletImpl() {
    }

    @Override
    public <T> Streamlet<T> map(SerializableFunction<R, ? extends T> mapFn) {
        StreamletUtils.checkNotNull(mapFn, "mapFn cannot be null");
        MapStreamlet<R, ? extends T> retval = new MapStreamlet<R, T>(this, mapFn);
        this.addChild(retval);
        return retval;
    }

    @Override
    public <T> Streamlet<T> flatMap(SerializableFunction<R, ? extends Iterable<? extends T>> flatMapFn) {
        StreamletUtils.checkNotNull(flatMapFn, "flatMapFn cannot be null");
        FlatMapStreamlet retval = new FlatMapStreamlet(this, flatMapFn);
        this.addChild(retval);
        return retval;
    }

    @Override
    public Streamlet<R> filter(SerializablePredicate<R> filterFn) {
        StreamletUtils.checkNotNull(filterFn, "filterFn cannot be null");
        FilterStreamlet<R> retval = new FilterStreamlet<R>(this, filterFn);
        this.addChild(retval);
        return retval;
    }

    @Override
    public Streamlet<R> repartition(int numPartitions) {
        return this.map(a -> a).setNumPartitions(numPartitions);
    }

    @Override
    public Streamlet<R> repartition(int numPartitions, SerializableBiFunction<R, Integer, List<Integer>> partitionFn) {
        StreamletUtils.checkNotNull(partitionFn, "partitionFn cannot be null");
        RemapStreamlet<R> retval = new RemapStreamlet<R>(this, partitionFn);
        retval.setNumPartitions(numPartitions);
        this.addChild(retval);
        return retval;
    }

    @Override
    public List<Streamlet<R>> clone(int numClones) {
        StreamletUtils.require(numClones > 0, "Streamlet's clone number should be > 0");
        ArrayList<Streamlet<R>> retval = new ArrayList<Streamlet<R>>(numClones);
        for (int i = 0; i < numClones; ++i) {
            retval.add(this.repartition(this.getNumPartitions()));
        }
        return retval;
    }

    @Override
    public <K, S, T> KVStreamlet<KeyedWindow<K>, T> join(Streamlet<S> otherStreamlet, SerializableFunction<R, K> thisKeyExtractor, SerializableFunction<S, K> otherKeyExtractor, WindowConfig windowCfg, SerializableBiFunction<R, S, ? extends T> joinFunction) {
        StreamletUtils.checkNotNull(otherStreamlet, "otherStreamlet cannot be null");
        StreamletUtils.checkNotNull(thisKeyExtractor, "thisKeyExtractor cannot be null");
        StreamletUtils.checkNotNull(otherKeyExtractor, "otherKeyExtractor cannot be null");
        StreamletUtils.checkNotNull(windowCfg, "windowCfg cannot be null");
        StreamletUtils.checkNotNull(joinFunction, "joinFunction cannot be null");
        return this.join(otherStreamlet, thisKeyExtractor, otherKeyExtractor, windowCfg, JoinType.INNER, joinFunction);
    }

    @Override
    public <K, S, T> KVStreamlet<KeyedWindow<K>, T> join(Streamlet<S> otherStreamlet, SerializableFunction<R, K> thisKeyExtractor, SerializableFunction<S, K> otherKeyExtractor, WindowConfig windowCfg, JoinType joinType, SerializableBiFunction<R, S, ? extends T> joinFunction) {
        StreamletUtils.checkNotNull(otherStreamlet, "otherStreamlet cannot be null");
        StreamletUtils.checkNotNull(thisKeyExtractor, "thisKeyExtractor cannot be null");
        StreamletUtils.checkNotNull(otherKeyExtractor, "otherKeyExtractor cannot be null");
        StreamletUtils.checkNotNull(windowCfg, "windowCfg cannot be null");
        StreamletUtils.checkNotNull(joinType, "joinType cannot be null");
        StreamletUtils.checkNotNull(joinFunction, "joinFunction cannot be null");
        StreamletImpl joinee = (StreamletImpl)otherStreamlet;
        JoinStreamlet<K, R, S, ? extends T> retval = JoinStreamlet.createJoinStreamlet(this, joinee, thisKeyExtractor, otherKeyExtractor, windowCfg, joinType, joinFunction);
        this.addChild(retval);
        joinee.addChild(retval);
        return new KVStreamletShadow(retval);
    }

    @Override
    public <K, T> KVStreamlet<K, T> reduceByKey(SerializableFunction<R, K> keyExtractor, SerializableFunction<R, T> valueExtractor, SerializableBinaryOperator<T> reduceFn) {
        StreamletUtils.checkNotNull(keyExtractor, "keyExtractor cannot be null");
        StreamletUtils.checkNotNull(valueExtractor, "valueExtractor cannot be null");
        StreamletUtils.checkNotNull(reduceFn, "reduceFn cannot be null");
        ReduceByKeyStreamlet<R, K, T> retval = new ReduceByKeyStreamlet<R, K, T>(this, keyExtractor, valueExtractor, reduceFn);
        this.addChild(retval);
        return new KVStreamletShadow(retval);
    }

    @Override
    public <K, T> KVStreamlet<K, T> reduceByKey(SerializableFunction<R, K> keyExtractor, T identity, SerializableBiFunction<T, R, ? extends T> reduceFn) {
        StreamletUtils.checkNotNull(keyExtractor, "keyExtractor cannot be null");
        StreamletUtils.checkNotNull(identity, "identity cannot be null");
        StreamletUtils.checkNotNull(reduceFn, "reduceFn cannot be null");
        GeneralReduceByKeyStreamlet<R, K, ? extends T> retval = new GeneralReduceByKeyStreamlet<R, K, T>(this, keyExtractor, identity, reduceFn);
        this.addChild(retval);
        return new KVStreamletShadow(retval);
    }

    @Override
    public <K, T> KVStreamlet<KeyedWindow<K>, T> reduceByKeyAndWindow(SerializableFunction<R, K> keyExtractor, SerializableFunction<R, T> valueExtractor, WindowConfig windowCfg, SerializableBinaryOperator<T> reduceFn) {
        StreamletUtils.checkNotNull(keyExtractor, "keyExtractor cannot be null");
        StreamletUtils.checkNotNull(valueExtractor, "valueExtractor cannot be null");
        StreamletUtils.checkNotNull(windowCfg, "windowCfg cannot be null");
        StreamletUtils.checkNotNull(reduceFn, "reduceFn cannot be null");
        ReduceByKeyAndWindowStreamlet<R, K, T> retval = new ReduceByKeyAndWindowStreamlet<R, K, T>(this, keyExtractor, valueExtractor, windowCfg, reduceFn);
        this.addChild(retval);
        return new KVStreamletShadow(retval);
    }

    @Override
    public <K, T> KVStreamlet<KeyedWindow<K>, T> reduceByKeyAndWindow(SerializableFunction<R, K> keyExtractor, WindowConfig windowCfg, T identity, SerializableBiFunction<T, R, ? extends T> reduceFn) {
        StreamletUtils.checkNotNull(keyExtractor, "keyExtractor cannot be null");
        StreamletUtils.checkNotNull(windowCfg, "windowCfg cannot be null");
        StreamletUtils.checkNotNull(identity, "identity cannot be null");
        StreamletUtils.checkNotNull(reduceFn, "reduceFn cannot be null");
        GeneralReduceByKeyAndWindowStreamlet<R, K, ? extends T> retval = new GeneralReduceByKeyAndWindowStreamlet<R, K, T>(this, keyExtractor, windowCfg, identity, reduceFn);
        this.addChild(retval);
        return new KVStreamletShadow(retval);
    }

    @Override
    public Streamlet<R> union(Streamlet<? extends R> otherStreamlet) {
        StreamletUtils.checkNotNull(otherStreamlet, "otherStreamlet cannot be null");
        StreamletImpl joinee = (StreamletImpl)otherStreamlet;
        UnionStreamlet retval = new UnionStreamlet(this, joinee);
        this.addChild(retval);
        joinee.addChild(retval);
        return retval;
    }

    @Override
    public StreamletBase<R> log() {
        LogStreamlet logger = new LogStreamlet(this);
        this.addChild(logger);
        return logger;
    }

    @Override
    public StreamletBase<R> consume(SerializableConsumer<R> consumer) {
        StreamletUtils.checkNotNull(consumer, "consumer cannot be null");
        ConsumerStreamlet<R> consumerStreamlet = new ConsumerStreamlet<R>(this, consumer);
        this.addChild(consumerStreamlet);
        return consumerStreamlet;
    }

    @Override
    public StreamletBase<R> toSink(Sink<R> sink) {
        StreamletUtils.checkNotNull(sink, "sink cannot be null");
        SinkStreamlet<R> sinkStreamlet = new SinkStreamlet<R>(this, sink);
        this.addChild(sinkStreamlet);
        return sinkStreamlet;
    }

    @Override
    public <T> Streamlet<T> transform(SerializableTransformer<R, ? extends T> serializableTransformer) {
        StreamletUtils.checkNotNull(serializableTransformer, "serializableTransformer cannot be null");
        TransformStreamlet<R, ? extends T> transformStreamlet = new TransformStreamlet<R, T>(this, serializableTransformer);
        this.addChild(transformStreamlet);
        return transformStreamlet;
    }

    @Override
    public <T> Streamlet<T> applyOperator(IStreamletOperator<R, T> operator) {
        StreamletUtils.checkNotNull(operator, "operator cannot be null");
        return this.applyOperator(operator, new NoneStreamGrouping());
    }

    @Override
    public <T> Streamlet<T> applyOperator(IStreamletOperator<R, T> operator, StreamGrouping grouper) {
        StreamletUtils.checkNotNull(operator, "operator can't be null");
        StreamletUtils.checkNotNull(grouper, "grouper can't be null");
        CustomStreamlet<R, T> customStreamlet = new CustomStreamlet<R, T>(this, operator, grouper);
        this.addChild(customStreamlet);
        return customStreamlet;
    }

    @Override
    public Streamlet<R> split(Map<String, SerializablePredicate<R>> splitFns) {
        StreamletUtils.require(splitFns.size() > 0, "At least one entry is required");
        StreamletUtils.require(splitFns.keySet().stream().allMatch(stream -> StringUtils.isNotBlank((CharSequence)stream)), "Stream Id can not be blank");
        SplitStreamlet<R> splitStreamlet = new SplitStreamlet<R>(this, splitFns);
        this.addChild(splitStreamlet);
        return splitStreamlet;
    }

    @Override
    public <K> KVStreamlet<K, R> keyBy(SerializableFunction<R, K> keyExtractor) {
        return this.keyBy(keyExtractor, a -> a);
    }

    @Override
    public <K, V> KVStreamlet<K, V> keyBy(SerializableFunction<R, K> keyExtractor, SerializableFunction<R, V> valueExtractor) {
        StreamletUtils.checkNotNull(keyExtractor, "keyExtractor cannot be null");
        StreamletUtils.checkNotNull(valueExtractor, "valueExtractor cannot be null");
        KeyByStreamlet<R, K, V> retval = new KeyByStreamlet<R, K, V>(this, keyExtractor, valueExtractor);
        this.addChild(retval);
        return new KVStreamletShadow(retval);
    }

    @Override
    public <K> KVStreamlet<K, Long> countByKey(SerializableFunction<R, K> keyExtractor) {
        StreamletUtils.checkNotNull(keyExtractor, "keyExtractor cannot be null");
        CountByKeyStreamlet<R, K> retval = new CountByKeyStreamlet<R, K>(this, keyExtractor);
        this.addChild(retval);
        return new KVStreamletShadow(retval);
    }

    @Override
    public <K> KVStreamlet<KeyedWindow<K>, Long> countByKeyAndWindow(SerializableFunction<R, K> keyExtractor, WindowConfig windowCfg) {
        StreamletUtils.checkNotNull(keyExtractor, "keyExtractor cannot be null");
        StreamletUtils.checkNotNull(windowCfg, "windowCfg cannot be null");
        CountByKeyAndWindowStreamlet<R, K> retval = new CountByKeyAndWindowStreamlet<R, K>(this, keyExtractor, windowCfg);
        this.addChild(retval);
        return new KVStreamletShadow<KeyedWindow<K>, Long>(retval);
    }
}

