/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.heron.api.spout.IRichSpout;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.Builder;
import org.apache.heron.streamlet.SerializableSupplier;
import org.apache.heron.streamlet.Source;
import org.apache.heron.streamlet.Streamlet;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.streamlets.SourceStreamlet;
import org.apache.heron.streamlet.impl.streamlets.SpoutStreamlet;
import org.apache.heron.streamlet.impl.streamlets.SupplierStreamlet;
import org.apache.heron.streamlet.impl.utils.StreamletUtils;

public final class BuilderImpl
implements Builder {
    private List<StreamletImpl<?>> sources = new LinkedList();

    @Override
    public <R> Streamlet<R> newSource(SerializableSupplier<R> supplier) {
        StreamletUtils.checkNotNull(supplier, "supplier cannot not be null");
        SupplierStreamlet<R> retval = new SupplierStreamlet<R>(supplier);
        this.sources.add(retval);
        return retval;
    }

    @Override
    public <R> Streamlet<R> newSource(Source<R> generator) {
        StreamletUtils.checkNotNull(generator, "generator cannot not be null");
        SourceStreamlet<R> retval = new SourceStreamlet<R>(generator);
        this.sources.add(retval);
        return retval;
    }

    @Override
    public <R> Streamlet<R> newSource(IRichSpout spout) {
        StreamletUtils.checkNotNull(spout, "spout cannot not be null");
        SpoutStreamlet retval = new SpoutStreamlet(spout);
        this.sources.add(retval);
        return retval;
    }

    public TopologyBuilder build() {
        TopologyBuilder builder = new TopologyBuilder();
        return this.build(builder);
    }

    public TopologyBuilder build(TopologyBuilder builder) {
        StreamletUtils.checkNotNull(builder, "builder cannot not be null");
        HashSet<String> stageNames = new HashSet<String>();
        for (StreamletImpl<?> streamlet : this.sources) {
            streamlet.build(builder, stageNames);
        }
        for (StreamletImpl<?> streamlet : this.sources) {
            if (streamlet.isFullyBuilt()) continue;
            throw new RuntimeException("Topology cannot be fully built! Are all sources added?");
        }
        return builder;
    }
}

