/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.apache.heron.api.serializer.IPluggableSerializer;

public class JavaSerializer
implements IPluggableSerializer {
    @Override
    public void initialize(Map<String, Object> config) {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(Object object) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(object);
                oos.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize object: " + object.toString(), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserialize(byte[] input) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(input);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                object = ois.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Failed to deserialize object", e);
        }
    }
}

