/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class UploaderUtils {
    public static final String DEFAULT_FILENAME_EXTENSION = ".tar.gz";

    private UploaderUtils() {
    }

    public static String generateFilename(String topologyName, String role) {
        return UploaderUtils.generateFilename(topologyName, role, "tag", 0, DEFAULT_FILENAME_EXTENSION);
    }

    public static String generateFilename(String topologyName, String role, String tag, int version, String extension) {
        return String.format("%s-%s-%s-%d%s", topologyName, role, tag, version, extension);
    }

    public static void copyToOutputStream(String inFile, OutputStream out) throws IOException {
        try (FileInputStream in = new FileInputStream(inFile);){
            int read = 0;
            byte[] bytes = new byte[131072];
            while ((read = ((InputStream)in).read(bytes)) >= 0) {
                if (0 == read) continue;
                out.write(bytes, 0, read);
            }
            out.flush();
            out.close();
        }
    }
}

