/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.proto.system.PhysicalPlans;
import org.apache.heron.proto.tmanager.TopologyManager;
import org.apache.heron.spi.statemgr.SchedulerStateManagerAdaptor;
import org.apache.heron.spi.utils.NetworkUtils;
import org.apache.heron.spi.utils.TManagerException;

public final class TManagerUtils {
    private static final Logger LOG = Logger.getLogger(TManagerUtils.class.getName());

    private TManagerUtils() {
    }

    @VisibleForTesting
    public static void sendToTManager(String command, String topologyName, SchedulerStateManagerAdaptor stateManager, NetworkUtils.TunnelConfig tunnelConfig) throws TManagerException {
        ArrayList<String> empty = new ArrayList<String>();
        TManagerUtils.sendToTManagerWithArguments(command, topologyName, empty, stateManager, tunnelConfig);
    }

    @VisibleForTesting
    public static void sendToTManagerWithArguments(String command, String topologyName, List<String> arguments, SchedulerStateManagerAdaptor stateManager, NetworkUtils.TunnelConfig tunnelConfig) throws TManagerException {
        LOG.fine("Fetching TManager location for topology: " + topologyName);
        TopologyManager.TManagerLocation location = stateManager.getTManagerLocation(topologyName);
        if (location == null) {
            throw new TManagerException("Failed to fetch TManager location for topology: " + topologyName);
        }
        LOG.fine("Fetched TManager location for topology: " + topologyName);
        String url = String.format("http://%s:%d/%s?topologyid=%s", location.getHost(), location.getControllerPort(), command, location.getTopologyId());
        for (String arg : arguments) {
            url = url + "&";
            url = url + arg;
        }
        try {
            URL endpoint = new URL(url);
            LOG.fine("HTTP URL for TManager: " + endpoint);
            TManagerUtils.sendGetRequest(endpoint, command, tunnelConfig);
        }
        catch (MalformedURLException e) {
            throw new TManagerException("Invalid URL for TManager endpoint: " + url, e);
        }
    }

    private static void sendGetRequest(URL endpoint, String command, NetworkUtils.TunnelConfig tunnelConfig) throws TManagerException {
        block7: {
            HttpURLConnection connection = NetworkUtils.getProxiedHttpConnectionIfNeeded(endpoint, tunnelConfig);
            if (connection == null) {
                throw new TManagerException(String.format("Failed to get a HTTP connection to TManager: %s", endpoint));
            }
            LOG.fine("Successfully opened HTTP connection to TManager");
            NetworkUtils.sendHttpGetRequest(connection);
            LOG.fine("Sent the HTTP payload to TManager");
            try {
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    LOG.fine("Successfully got a HTTP response from TManager using command: " + command);
                    break block7;
                }
                throw new TManagerException(String.format("Non OK HTTP response %d from TManager for command %s", responseCode, command));
            }
            catch (IOException e) {
                throw new TManagerException(String.format("Failed to receive HTTP response from TManager using command: `%s`", command), e);
            }
            finally {
                connection.disconnect();
            }
        }
    }

    private static TopologyAPI.TopologyState getRuntimeTopologyState(String topologyName, SchedulerStateManagerAdaptor statemgr) throws TManagerException {
        PhysicalPlans.PhysicalPlan plan = statemgr.getPhysicalPlan(topologyName);
        if (plan == null) {
            throw new TManagerException(String.format("Failed to get physical plan for topology '%s'", topologyName));
        }
        return plan.getTopology().getState();
    }

    public static void transitionTopologyState(String topologyName, TManagerCommand topologyStateControlCommand, SchedulerStateManagerAdaptor statemgr, TopologyAPI.TopologyState startState, TopologyAPI.TopologyState expectedState, NetworkUtils.TunnelConfig tunnelConfig) throws TManagerException {
        TopologyAPI.TopologyState state = TManagerUtils.getRuntimeTopologyState(topologyName, statemgr);
        if (state == null) {
            throw new TManagerException(String.format("Topology '%s' is not initialized yet", topologyName));
        }
        if (state == expectedState) {
            LOG.warning(String.format("Topology %s command received but topology '%s' already in state %s", new Object[]{topologyStateControlCommand, topologyName, state}));
            return;
        }
        if (state != startState) {
            throw new TManagerException(String.format("Topology '%s' is not in state '%s'", topologyName, startState));
        }
        String command = topologyStateControlCommand.name().toLowerCase();
        TManagerUtils.sendToTManager(command, topologyName, statemgr, tunnelConfig);
        LOG.log(Level.INFO, "Topology command {0} completed successfully.", (Object)topologyStateControlCommand);
    }

    public static void sendRuntimeConfig(String topologyName, TManagerCommand topologyStateControlCommand, SchedulerStateManagerAdaptor statemgr, String[] configs, NetworkUtils.TunnelConfig tunnelConfig) throws TManagerException {
        String runtimeConfigKey = "runtime-config";
        String runtimeConfigUpdateEndpoint = "runtime_config/update";
        ArrayList<String> arguments = new ArrayList<String>();
        for (String config : configs) {
            arguments.add("runtime-config=" + config);
        }
        TManagerUtils.sendToTManagerWithArguments("runtime_config/update", topologyName, arguments, statemgr, tunnelConfig);
        LOG.log(Level.INFO, "Topology command {0} completed successfully.", (Object)topologyStateControlCommand);
    }

    public static enum TManagerCommand {
        ACTIVATE,
        DEACTIVATE,
        RUNTIME_CONFIG_UPDATE;

    }
}

