/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ShellUtils {
    private static final Logger LOG = Logger.getLogger(ShellUtils.class.getName());

    private ShellUtils() {
    }

    @VisibleForTesting
    static String inputstreamToString(InputStream is) {
        char[] buffer = new char[2048];
        StringBuilder builder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            int readSize;
            while (0 <= (readSize = ((Reader)reader).read(buffer, 0, buffer.length))) {
                builder.append(buffer, 0, readSize);
                buffer = new char[2048];
            }
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Failed to read stream ", ioe);
        }
        return builder.toString();
    }

    public static int runProcess(String[] cmdline, StringBuilder outputBuilder) {
        return ShellUtils.runSyncProcess(true, false, cmdline, outputBuilder, null);
    }

    public static int runProcess(String cmdline, StringBuilder outputBuilder) {
        return ShellUtils.runSyncProcess(true, false, ShellUtils.splitTokens(cmdline), outputBuilder, null);
    }

    public static int runSyncProcess(boolean isVerbose, boolean isInheritIO, String[] cmdline, StringBuilder outputBuilder, File workingDirectory) {
        return ShellUtils.runSyncProcess(isVerbose, isInheritIO, cmdline, outputBuilder, workingDirectory, new HashMap<String, String>());
    }

    private static Thread createAsyncStreamThread(final InputStream input, final StringBuilder processOutputStringBuilder, final boolean isVerbose) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                LOG.log(Level.FINE, "Process output (stdout+stderr):");
                BufferedReader reader = new BufferedReader(new InputStreamReader(input), 1);
                while (true) {
                    String line = null;
                    try {
                        line = reader.readLine();
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "Error when reading line from subprocess", e);
                    }
                    if (line == null) break;
                    if (isVerbose) {
                        System.err.println(line);
                    }
                    if (processOutputStringBuilder == null) continue;
                    processOutputStringBuilder.append(line);
                }
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "Failed to close the input stream", e);
                }
            }
        };
        thread.setDaemon(true);
        return thread;
    }

    private static int runSyncProcess(boolean isVerbose, boolean isInheritIO, String[] cmdline, StringBuilder outputBuilder, File workingDirectory, Map<String, String> envs) {
        Process process;
        StringBuilder builder = outputBuilder == null ? new StringBuilder() : outputBuilder;
        LOG.log(Level.FINE, "Running synced process: ``{0}''''", ShellUtils.joinString(cmdline));
        ProcessBuilder pb = ShellUtils.getProcessBuilder(isInheritIO, cmdline, workingDirectory, envs);
        pb.redirectErrorStream(true);
        try {
            process = pb.start();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to run synced process", e);
            return -1;
        }
        Thread outputsThread = ShellUtils.createAsyncStreamThread(process.getInputStream(), builder, isVerbose);
        try {
            outputsThread.start();
            int exitValue = process.waitFor();
            outputsThread.join();
            return exitValue;
        }
        catch (InterruptedException e) {
            outputsThread.interrupt();
            process.destroy();
            LOG.log(Level.SEVERE, "Running synced process was interrupted", e);
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    public static Process runASyncProcess(String[] command, File workingDirectory, String logFileUuid) {
        return ShellUtils.runASyncProcess(command, workingDirectory, new HashMap<String, String>(), logFileUuid, true);
    }

    public static Process runASyncProcess(boolean verbose, String[] command, File workingDirectory) {
        return ShellUtils.runASyncProcess(command, workingDirectory, new HashMap<String, String>(), null, true);
    }

    public static Process runASyncProcess(boolean verbose, String[] command, File workingDirectory, Map<String, String> envs) {
        return ShellUtils.runASyncProcess(command, workingDirectory, envs, null, true);
    }

    public static Process runASyncProcess(String command) {
        return ShellUtils.runASyncProcess(ShellUtils.splitTokens(command), new File("."), new HashMap<String, String>(), null, false);
    }

    private static Process runASyncProcess(String[] command, File workingDirectory, Map<String, String> envs, String logFileUuid, boolean logStderr) {
        LOG.log(Level.FINE, "Running async process: ``{0}''''", ShellUtils.joinString(command));
        String commandFileName = Paths.get(command[0], new String[0]).getFileName().toString();
        String uuid = logFileUuid;
        if (uuid == null) {
            uuid = UUID.randomUUID().toString().substring(0, 8) + "-started";
        }
        ProcessBuilder pb = ShellUtils.getProcessBuilder(false, command, workingDirectory, envs);
        pb.redirectErrorStream(true);
        if (logStderr) {
            String logFilePath = String.format("%s/%s-%s.stderr", workingDirectory, commandFileName, uuid);
            pb.redirectOutput(ProcessBuilder.Redirect.appendTo(new File(logFilePath)));
        }
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to run async process", e);
        }
        return process;
    }

    protected static String[] splitTokens(String command) {
        if (command.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return cmdarray;
    }

    protected static ProcessBuilder getProcessBuilder(boolean isInheritIO, String[] command, File workingDirectory, Map<String, String> envs) {
        ProcessBuilder pb = new ProcessBuilder(command).directory(workingDirectory);
        if (isInheritIO) {
            pb.inheritIO();
        }
        Map<String, String> env = pb.environment();
        for (String envKey : envs.keySet()) {
            env.put(envKey, envs.get(envKey));
        }
        return pb;
    }

    static Process establishSSHTunnelProcess(String tunnelHost, int tunnelPort, String destHost, int destPort) {
        if (destHost == null || destHost.isEmpty() || "localhost".equals(destHost) || "127.0.0.1".equals(destHost)) {
            throw new RuntimeException("Trying to open tunnel to localhost.");
        }
        return ShellUtils.runASyncProcess(String.format("ssh -NL%d:%s:%d %s", tunnelPort, destHost, destPort, tunnelHost));
    }

    static Process establishSocksProxyProcess(String proxyHost, int proxyPort) {
        LOG.info(String.format("Establishing SOCKS proxy to: %s:%d", proxyHost, proxyPort));
        return ShellUtils.runASyncProcess(String.format("ssh -ND %d %s", proxyPort, proxyHost));
    }

    public static boolean curlPackage(String uri, String destination, boolean isVerbose, boolean isInheritIO) {
        File parentDirectory = Paths.get(destination, new String[0]).getParent().toFile();
        String cmd = String.format("curl %s -o %s", uri, destination);
        int ret = ShellUtils.runSyncProcess(isVerbose, isInheritIO, ShellUtils.splitTokens(cmd), new StringBuilder(), parentDirectory);
        return ret == 0;
    }

    public static boolean extractPackage(String packageName, String targetFolder, boolean isVerbose, boolean isInheritIO) {
        String cmd = String.format("tar -xvf %s", packageName);
        int ret = ShellUtils.runSyncProcess(isVerbose, isInheritIO, ShellUtils.splitTokens(cmd), new StringBuilder(), new File(targetFolder));
        return ret == 0;
    }

    private static String joinString(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (String value : array) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(value);
        }
        return sb.toString();
    }
}

