/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.common.basics.ByteAmount;
import org.apache.heron.common.basics.Pair;
import org.apache.heron.common.basics.ResourceMeasure;
import org.apache.heron.common.utils.topology.TopologyTests;
import org.apache.heron.proto.system.PackingPlans;
import org.apache.heron.spi.common.Config;
import org.apache.heron.spi.common.Key;
import org.apache.heron.spi.packing.IPacking;
import org.apache.heron.spi.packing.InstanceId;
import org.apache.heron.spi.packing.PackingPlan;
import org.apache.heron.spi.packing.PackingPlanProtoSerializer;
import org.apache.heron.spi.packing.Resource;

public final class PackingTestUtils {
    private PackingTestUtils() {
    }

    public static PackingPlan testPackingPlan(String topologyName, IPacking packing) {
        HashMap<String, Integer> spouts = new HashMap<String, Integer>();
        spouts.put("testSpout", 2);
        HashMap<String, Integer> bolts = new HashMap<String, Integer>();
        bolts.put("testBolt", 3);
        org.apache.heron.api.Config topologyConfig = new org.apache.heron.api.Config();
        topologyConfig.put("topology.stmgrs", 1);
        TopologyAPI.Topology topology = TopologyTests.createTopology(topologyName, topologyConfig, spouts, bolts);
        Config config = Config.newBuilder(true).put(Key.TOPOLOGY_ID, (Object)topology.getId()).put(Key.TOPOLOGY_NAME, (Object)topology.getName()).build();
        packing.initialize(config, topology);
        return packing.pack();
    }

    public static PackingPlans.PackingPlan testProtoPackingPlan(String topologyName, IPacking packing) {
        PackingPlan plan = PackingTestUtils.testPackingPlan(topologyName, packing);
        PackingPlanProtoSerializer serializer = new PackingPlanProtoSerializer();
        return serializer.toProto(plan);
    }

    public static PackingPlan.ContainerPlan testContainerPlan(int containerId) {
        return PackingTestUtils.testContainerPlan(containerId, 0, 1);
    }

    public static PackingPlan.ContainerPlan testContainerPlan(int containerId, Integer ... instanceIndices) {
        ArrayList<Pair<String, Integer>> instanceInfo = new ArrayList<Pair<String, Integer>>();
        Integer[] integerArray = instanceIndices;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int instanceIndex = integerArray[i];
            String componentName = "componentName-" + instanceIndex;
            instanceInfo.add(new Pair<String, Integer>(componentName, instanceIndex));
        }
        return PackingTestUtils.testContainerPlan(containerId, instanceInfo.toArray((Pair[])Array.newInstance(Pair.class, instanceInfo.size())));
    }

    @SafeVarargs
    public static PackingPlan.ContainerPlan testContainerPlan(int containerId, Pair<String, Integer> ... instanceInfo) {
        double cpu = 1.5;
        ResourceMeasure ram = ByteAmount.fromGigabytes(1L);
        HashSet<PackingPlan.InstancePlan> instancePlans = new HashSet<PackingPlan.InstancePlan>();
        for (Pair<String, Integer> info : instanceInfo) {
            PackingPlan.InstancePlan instance = PackingTestUtils.testInstancePlan((String)info.first, (Integer)info.second);
            instancePlans.add(instance);
            cpu += instance.getResource().getCpu();
            ram = ram.plus((ResourceMeasure)instance.getResource().getRam());
        }
        Resource resource = new Resource(cpu, (ByteAmount)ram, (ByteAmount)ram);
        return new PackingPlan.ContainerPlan(containerId, instancePlans, resource);
    }

    public static PackingPlan.InstancePlan testInstancePlan(String componentName, int instanceIndex) {
        Resource resource = new Resource(1.5, ByteAmount.fromGigabytes(2L), ByteAmount.fromBytes(3L));
        return new PackingPlan.InstancePlan(new InstanceId(componentName, instanceIndex, 1), resource);
    }

    public static Config newTestConfig(TopologyAPI.Topology topology) {
        return Config.newBuilder(true).put(Key.TOPOLOGY_ID, (Object)topology.getId()).put(Key.TOPOLOGY_NAME, (Object)topology.getName()).build();
    }
}

