/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.utils;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.common.basics.Pair;
import org.apache.heron.common.basics.SysUtils;
import org.apache.heron.spi.common.Config;
import org.apache.heron.spi.utils.ShellUtils;

public final class NetworkUtils {
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CONTENT_TYPE = "Content-Type";
    static final String LOCAL_HOST = "localhost";
    public static final String JSON_TYPE = "application/json";
    public static final String URL_ENCODE_TYPE = "application/x-www-form-urlencoded";
    private static final Logger LOG = Logger.getLogger(NetworkUtils.class.getName());

    private NetworkUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readHttpRequestBody(HttpExchange exchange) {
        int contentLength = Integer.parseInt(exchange.getRequestHeaders().getFirst(CONTENT_LENGTH));
        if (contentLength <= 0) {
            LOG.log(Level.SEVERE, "Failed to read content length http request body: " + contentLength);
            return new byte[0];
        }
        byte[] requestBody = new byte[contentLength];
        InputStream is = exchange.getRequestBody();
        try {
            int bRead = 0;
            for (int off = 0; off != contentLength - 1 && (bRead = is.read(requestBody, off, contentLength - off)) != -1; off += bRead) {
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to read http request body: ", e);
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close InputStream: ", e);
                return new byte[0];
            }
        }
        return requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendHttpResponse(boolean isSuccess, HttpExchange exchange, byte[] response) {
        int returnCode = isSuccess ? 200 : 503;
        try {
            exchange.sendResponseHeaders(returnCode, response.length);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to send response headers: ", e);
            return false;
        }
        OutputStream os = exchange.getResponseBody();
        try {
            os.write(response);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to send http response: ", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close OutputStream: ", e);
                return false;
            }
        }
        return true;
    }

    public static boolean sendHttpResponse(HttpExchange exchange, byte[] response) {
        return NetworkUtils.sendHttpResponse(true, exchange, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendHttpPostRequest(HttpURLConnection connection, String contentType, byte[] data) {
        try {
            connection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            LOG.log(Level.SEVERE, "Failed to set post request: ", e);
            return false;
        }
        if (data.length > 0) {
            connection.setRequestProperty(CONTENT_TYPE, contentType);
            connection.setRequestProperty(CONTENT_LENGTH, Integer.toString(data.length));
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            OutputStream os = null;
            try {
                os = connection.getOutputStream();
                os.write(data);
                os.flush();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to send request: ", e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Failed to close OutputStream: ", e);
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean sendHttpGetRequest(HttpURLConnection connection) {
        try {
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
        }
        catch (ProtocolException e) {
            LOG.log(Level.SEVERE, "Failed to send http get request: " + connection);
            return false;
        }
        return true;
    }

    public static boolean sendHttpDeleteRequest(HttpURLConnection connection) {
        try {
            connection.setRequestMethod("DELETE");
        }
        catch (ProtocolException e) {
            LOG.log(Level.SEVERE, "Failed to send http delete request: " + connection);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readHttpResponse(HttpURLConnection connection) {
        try {
            if (connection.getResponseCode() != 200) {
                LOG.log(Level.WARNING, "Http Response not OK: " + connection.getResponseCode());
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to get response code", e);
            return new byte[0];
        }
        int responseLength = connection.getContentLength();
        if (responseLength <= 0) {
            LOG.log(Level.SEVERE, "Response length abnormal: " + responseLength);
            return new byte[0];
        }
        try {
            byte[] res = new byte[responseLength];
            InputStream is = connection.getInputStream();
            int bRead = 0;
            for (int off = 0; off != responseLength - 1 && (bRead = is.read(res, off, responseLength - off)) != -1; off += bRead) {
            }
            byte[] byArray = res;
            return byArray;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to read response: ", e);
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            try {
                connection.getInputStream().close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close InputStream: ", e);
                return new byte[0];
            }
        }
    }

    public static HttpURLConnection getHttpConnection(String endpoint) {
        try {
            return NetworkUtils.getHttpConnection(new URL(endpoint), null);
        }
        catch (MalformedURLException e) {
            LOG.log(Level.SEVERE, "Invalid URL received: " + endpoint, e);
            return null;
        }
    }

    public static HttpURLConnection getProxiedHttpConnectionIfNeeded(URL endpoint, TunnelConfig tunnelConfig) {
        int endpointPort;
        int n = endpointPort = endpoint.getPort() > 0 ? endpoint.getPort() : endpoint.getDefaultPort();
        if (tunnelConfig != null && tunnelConfig.isTunnelNeeded()) {
            InetSocketAddress socketEndpoint = new InetSocketAddress(endpoint.getHost(), endpointPort);
            Pair<InetSocketAddress, Process> tunnelInfo = NetworkUtils.establishSSHTunnelIfNeeded(socketEndpoint, tunnelConfig, TunnelType.SOCKS_PROXY);
            InetSocketAddress proxyEndpoint = (InetSocketAddress)tunnelInfo.first;
            if (socketEndpoint != proxyEndpoint) {
                Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyEndpoint.getHostName(), proxyEndpoint.getPort()));
                LOG.fine(String.format("setting up proxy. endpoint=%s proxy=%s", socketEndpoint, proxy));
                return NetworkUtils.getHttpConnection(endpoint, proxy);
            }
        }
        return NetworkUtils.getHttpConnection(endpoint, null);
    }

    private static HttpURLConnection getHttpConnection(URL endpoint, Proxy proxy) {
        try {
            if (proxy != null) {
                return (HttpURLConnection)endpoint.openConnection(proxy);
            }
            return (HttpURLConnection)endpoint.openConnection();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to connect to http endpoint " + endpoint, e);
            return null;
        }
    }

    public static boolean checkHttpResponseCode(HttpURLConnection connection, int expectedCode) {
        try {
            return connection.getResponseCode() == expectedCode;
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Failed to get response code");
            return false;
        }
    }

    public static String getHostName() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Unable to get local host name", e);
            hostName = LOCAL_HOST;
        }
        return hostName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isLocationReachable(InetSocketAddress endpoint, Duration timeout, int retryCount, Duration retryInterval) {
        for (int retryLeft = retryCount; retryLeft > 0; --retryLeft) {
            Socket s = new Socket();
            s.connect(endpoint, (int)timeout.toMillis());
            boolean bl = true;
            s.close();
            SysUtils.sleep(retryInterval);
            --retryLeft;
            return bl;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            try {
                                s.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            SysUtils.sleep(retryInterval);
                            continue;
                        }
                    }
                    catch (Throwable throwable3) {
                        SysUtils.sleep(retryInterval);
                        --retryLeft;
                        throw throwable3;
                    }
                }
            }
        }
        LOG.log(Level.FINE, "Failed to connect to: {0}", endpoint.toString());
        return false;
    }

    public static Pair<InetSocketAddress, Process> establishSSHTunnelIfNeeded(InetSocketAddress endpoint, TunnelConfig tunnelConfig, TunnelType tunnelType) {
        return NetworkUtils.establishSSHTunnelIfNeeded(endpoint, tunnelConfig.getTunnelHost(), tunnelType, tunnelConfig.getTimeout(), tunnelConfig.getRetryCount(), tunnelConfig.getRetryInterval(), tunnelConfig.getVerifyCount());
    }

    private static Pair<InetSocketAddress, Process> establishSSHTunnelIfNeeded(InetSocketAddress endpoint, String tunnelHost, TunnelType tunnelType, Duration timeout, int retryCount, Duration retryInterval, int verifyCount) {
        Process tunnelProcess;
        if (NetworkUtils.isLocationReachable(endpoint, timeout, retryCount, retryInterval)) {
            return new Pair<InetSocketAddress, Object>(endpoint, null);
        }
        int localFreePort = SysUtils.getFreePort();
        InetSocketAddress newEndpoint = new InetSocketAddress(LOCAL_HOST, localFreePort);
        LOG.log(Level.FINE, "Trying to opening up tunnel to {0} from {1}", new Object[]{endpoint.toString(), newEndpoint.toString()});
        switch (tunnelType) {
            case PORT_FORWARD: {
                tunnelProcess = ShellUtils.establishSSHTunnelProcess(tunnelHost, localFreePort, endpoint.getHostString(), endpoint.getPort());
                break;
            }
            case SOCKS_PROXY: {
                tunnelProcess = ShellUtils.establishSocksProxyProcess(tunnelHost, localFreePort);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized TunnelType passed: " + (Object)((Object)tunnelType));
            }
        }
        if (tunnelProcess != null && tunnelProcess.isAlive() && NetworkUtils.isLocationReachable(newEndpoint, timeout, verifyCount, retryInterval)) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    tunnelProcess.destroy();
                }
            });
            return new Pair<InetSocketAddress, Process>(newEndpoint, tunnelProcess);
        }
        LOG.log(Level.FINE, "Failed to opening up tunnel to {0} from {1}. Releasing process..", new Object[]{endpoint, newEndpoint});
        tunnelProcess.destroy();
        return new Pair<Object, Object>(null, null);
    }

    public static InetSocketAddress getInetSocketAddress(String endpoint) {
        String[] array = endpoint.split(":");
        return new InetSocketAddress(array[0], Integer.parseInt(array[1]));
    }

    public static class TunnelConfig {
        private static final String IS_TUNNEL_NEEDED = "heron.%s.is.tunnel.needed";
        private static final String TUNNEL_CONNECTION_TIMEOUT_MS = "heron.%s.tunnel.connection.timeout.ms";
        private static final String TUNNEL_CONNECTION_RETRY_COUNT = "heron.%s.tunnel.connection.retryCount.count";
        private static final String TUNNEL_VERIFY_COUNT = "heron.%s.tunnel.verify.count";
        private static final String TUNNEL_RETRY_INTERVAL_MS = "heron.%s.tunnel.retryCount.interval.ms";
        private static final String TUNNEL_HOST = "heron.%s.tunnel.host";
        private final boolean isTunnelNeeded;
        private final String tunnelHost;
        private final Duration timeout;
        private final int retryCount;
        private final Duration retryInterval;
        private final int verifyCount;

        TunnelConfig(boolean isTunnelNeeded, String tunnelHost, Duration timeout, int retryCount, Duration retryInterval, int verifyCount) {
            this.isTunnelNeeded = isTunnelNeeded;
            this.tunnelHost = tunnelHost;
            this.timeout = timeout;
            this.retryCount = retryCount;
            this.retryInterval = retryInterval;
            this.verifyCount = verifyCount;
        }

        public boolean isTunnelNeeded() {
            return this.isTunnelNeeded;
        }

        public String getTunnelHost() {
            return this.tunnelHost;
        }

        private Duration getTimeout() {
            return this.timeout;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        private Duration getRetryInterval() {
            return this.retryInterval;
        }

        private int getVerifyCount() {
            return this.verifyCount;
        }

        public static TunnelConfig build(Config config, HeronSystem heronSystem) {
            return new TunnelConfig(config.getBooleanValue(TunnelConfig.getConfigKey(IS_TUNNEL_NEEDED, heronSystem), false), config.getStringValue(TunnelConfig.getConfigKey(TUNNEL_HOST, heronSystem), "no.tunnel.host.specified"), config.getDurationValue(TunnelConfig.getConfigKey(TUNNEL_CONNECTION_TIMEOUT_MS, heronSystem), ChronoUnit.MILLIS, Duration.ofSeconds(1L)), config.getIntegerValue(TunnelConfig.getConfigKey(TUNNEL_CONNECTION_RETRY_COUNT, heronSystem), 2), config.getDurationValue(TunnelConfig.getConfigKey(TUNNEL_RETRY_INTERVAL_MS, heronSystem), ChronoUnit.MILLIS, Duration.ofSeconds(1L)), config.getIntegerValue(TunnelConfig.getConfigKey(TUNNEL_VERIFY_COUNT, heronSystem), 10));
        }

        private static String getConfigKey(String keyTemplate, HeronSystem heronSystem) {
            return String.format(keyTemplate, heronSystem.getShortName());
        }
    }

    public static enum HeronSystem {
        STATE_MANAGER("statemgr"),
        SCHEDULER("scheduler");

        private String shortName;

        private HeronSystem(String shortName) {
            this.shortName = shortName;
        }

        public String getShortName() {
            return this.shortName;
        }
    }

    public static enum TunnelType {
        PORT_FORWARD,
        SOCKS_PROXY;

    }
}

