/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.statemgr;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.proto.scheduler.Scheduler;
import org.apache.heron.proto.system.ExecutionEnvironment;
import org.apache.heron.proto.system.PackingPlans;
import org.apache.heron.proto.system.PhysicalPlans;
import org.apache.heron.proto.tmanager.TopologyManager;
import org.apache.heron.spi.statemgr.IStateManager;
import org.apache.heron.spi.statemgr.Lock;

public class SchedulerStateManagerAdaptor {
    private static final Logger LOG = Logger.getLogger(SchedulerStateManagerAdaptor.class.getName());
    private final IStateManager delegate;
    private final int timeout;

    public SchedulerStateManagerAdaptor(IStateManager delegate, int timeout) {
        this.delegate = delegate;
        this.timeout = timeout;
    }

    protected <V> V awaitResult(ListenableFuture<V> future) {
        return this.awaitResult(future, this.timeout, TimeUnit.MILLISECONDS);
    }

    protected <V> V awaitResult(ListenableFuture<V> future, int time, TimeUnit unit) {
        try {
            return future.get(time, unit);
        }
        catch (ExecutionException e) {
            LOG.log(Level.WARNING, "Exception processing future: " + e.getMessage());
            future.cancel(true);
            return null;
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.log(Level.SEVERE, "Exception processing future ", e);
            future.cancel(true);
            return null;
        }
    }

    public Lock getLock(String topologyName, IStateManager.LockName lockName) {
        return this.delegate.getLock(topologyName, lockName);
    }

    public Boolean isTopologyRunning(String topologyName) {
        return this.awaitResult(this.delegate.isTopologyRunning(topologyName));
    }

    public Boolean setExecutionState(ExecutionEnvironment.ExecutionState executionState, String topologyName) {
        return this.awaitResult(this.delegate.setExecutionState(executionState, topologyName));
    }

    public Boolean setTopology(TopologyAPI.Topology topology, String topologyName) {
        return this.awaitResult(this.delegate.setTopology(topology, topologyName));
    }

    public Boolean updateTopology(TopologyAPI.Topology topology, String topologyName) {
        if (this.getTopology(topologyName) != null) {
            this.deleteTopology(topologyName);
        }
        return this.setTopology(topology, topologyName);
    }

    public Boolean setSchedulerLocation(Scheduler.SchedulerLocation location, String topologyName) {
        return this.awaitResult(this.delegate.setSchedulerLocation(location, topologyName));
    }

    public Boolean setPackingPlan(PackingPlans.PackingPlan packingPlan, String topologyName) {
        return this.awaitResult(this.delegate.setPackingPlan(packingPlan, topologyName));
    }

    public Boolean updatePackingPlan(PackingPlans.PackingPlan packingPlan, String topologyName) {
        if (this.getPackingPlan(topologyName) != null) {
            this.deletePackingPlan(topologyName);
        }
        return this.setPackingPlan(packingPlan, topologyName);
    }

    public Boolean deleteTManagerLocation(String topologyName) {
        return this.awaitResult(this.delegate.deleteTManagerLocation(topologyName));
    }

    public Boolean deleteMetricsCacheLocation(String topologyName) {
        return this.awaitResult(this.delegate.deleteMetricsCacheLocation(topologyName));
    }

    public Boolean deleteExecutionState(String topologyName) {
        return this.awaitResult(this.delegate.deleteExecutionState(topologyName));
    }

    public Boolean deleteTopology(String topologyName) {
        return this.awaitResult(this.delegate.deleteTopology(topologyName));
    }

    public Boolean deletePackingPlan(String topologyName) {
        return this.awaitResult(this.delegate.deletePackingPlan(topologyName));
    }

    public Boolean deletePhysicalPlan(String topologyName) {
        return this.awaitResult(this.delegate.deletePhysicalPlan(topologyName));
    }

    public Boolean deleteSchedulerLocation(String topologyName) {
        return this.awaitResult(this.delegate.deleteSchedulerLocation(topologyName));
    }

    public Boolean deleteLocks(String topologyName) {
        return this.awaitResult(this.delegate.deleteLocks(topologyName));
    }

    public Boolean deleteStatefulCheckpoint(String topologyName) {
        return this.awaitResult(this.delegate.deleteStatefulCheckpoints(topologyName));
    }

    public TopologyManager.TManagerLocation getTManagerLocation(String topologyName) {
        return this.awaitResult(this.delegate.getTManagerLocation(null, topologyName));
    }

    public Scheduler.SchedulerLocation getSchedulerLocation(String topologyName) {
        return this.awaitResult(this.delegate.getSchedulerLocation(null, topologyName));
    }

    public TopologyManager.MetricsCacheLocation getMetricsCacheLocation(String topologyName) {
        return this.awaitResult(this.delegate.getMetricsCacheLocation(null, topologyName));
    }

    public TopologyAPI.Topology getTopology(String topologyName) {
        return this.awaitResult(this.delegate.getTopology(null, topologyName));
    }

    public ExecutionEnvironment.ExecutionState getExecutionState(String topologyName) {
        return this.awaitResult(this.delegate.getExecutionState(null, topologyName));
    }

    public PhysicalPlans.PhysicalPlan getPhysicalPlan(String topologyName) {
        return this.awaitResult(this.delegate.getPhysicalPlan(null, topologyName));
    }

    public PackingPlans.PackingPlan getPackingPlan(String topologyName) {
        return this.awaitResult(this.delegate.getPackingPlan(null, topologyName));
    }
}

