/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.statemgr;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.classification.InterfaceAudience;
import org.apache.heron.classification.InterfaceStability;
import org.apache.heron.proto.ckptmgr.CheckpointManager;
import org.apache.heron.proto.scheduler.Scheduler;
import org.apache.heron.proto.system.ExecutionEnvironment;
import org.apache.heron.proto.system.PackingPlans;
import org.apache.heron.proto.system.PhysicalPlans;
import org.apache.heron.proto.tmanager.TopologyManager;
import org.apache.heron.spi.common.Config;
import org.apache.heron.spi.statemgr.Lock;
import org.apache.heron.spi.statemgr.WatchCallback;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Unstable
public interface IStateManager
extends AutoCloseable {
    public void initialize(Config var1);

    @Override
    public void close();

    public ListenableFuture<Boolean> isTopologyRunning(String var1);

    public Lock getLock(String var1, LockName var2);

    public ListenableFuture<Boolean> deleteLocks(String var1);

    public ListenableFuture<Boolean> setTManagerLocation(TopologyManager.TManagerLocation var1, String var2);

    public ListenableFuture<TopologyManager.TManagerLocation> getTManagerLocation(WatchCallback var1, String var2);

    public ListenableFuture<Boolean> deleteTManagerLocation(String var1);

    public ListenableFuture<Boolean> setMetricsCacheLocation(TopologyManager.MetricsCacheLocation var1, String var2);

    public ListenableFuture<TopologyManager.MetricsCacheLocation> getMetricsCacheLocation(WatchCallback var1, String var2);

    public ListenableFuture<Boolean> deleteMetricsCacheLocation(String var1);

    public ListenableFuture<Boolean> setTopology(TopologyAPI.Topology var1, String var2);

    public ListenableFuture<TopologyAPI.Topology> getTopology(WatchCallback var1, String var2);

    public ListenableFuture<Boolean> deleteTopology(String var1);

    public ListenableFuture<Boolean> setPackingPlan(PackingPlans.PackingPlan var1, String var2);

    public ListenableFuture<PackingPlans.PackingPlan> getPackingPlan(WatchCallback var1, String var2);

    public ListenableFuture<Boolean> deletePackingPlan(String var1);

    public ListenableFuture<Boolean> setPhysicalPlan(PhysicalPlans.PhysicalPlan var1, String var2);

    public ListenableFuture<PhysicalPlans.PhysicalPlan> getPhysicalPlan(WatchCallback var1, String var2);

    public ListenableFuture<Boolean> deletePhysicalPlan(String var1);

    public ListenableFuture<Boolean> setExecutionState(ExecutionEnvironment.ExecutionState var1, String var2);

    public ListenableFuture<ExecutionEnvironment.ExecutionState> getExecutionState(WatchCallback var1, String var2);

    public ListenableFuture<Boolean> deleteExecutionState(String var1);

    public ListenableFuture<Boolean> setSchedulerLocation(Scheduler.SchedulerLocation var1, String var2);

    public ListenableFuture<Scheduler.SchedulerLocation> getSchedulerLocation(WatchCallback var1, String var2);

    public ListenableFuture<Boolean> deleteSchedulerLocation(String var1);

    public ListenableFuture<Boolean> setStatefulCheckpoints(CheckpointManager.StatefulConsistentCheckpoints var1, String var2);

    public ListenableFuture<CheckpointManager.StatefulConsistentCheckpoints> getStatefulCheckpoints(WatchCallback var1, String var2);

    public ListenableFuture<Boolean> deleteStatefulCheckpoints(String var1);

    public static enum LockName {
        UPDATE_TOPOLOGY("updateTopology");

        private String name;

        private LockName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

