/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.packing;

import org.apache.heron.common.basics.ByteAmount;
import org.apache.heron.common.basics.ResourceMeasure;

public class Resource {
    private double cpu;
    private ByteAmount ram;
    private ByteAmount disk;
    public static final Resource EMPTY_RESOURCE = new Resource(0.0, ByteAmount.ZERO, ByteAmount.ZERO);

    public Resource(double cpu, ByteAmount ram, ByteAmount disk) {
        this.cpu = cpu;
        this.ram = ram;
        this.disk = disk;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Resource) {
            Resource r = (Resource)obj;
            return this.getCpu() == r.getCpu() && this.getRam().equals(r.getRam()) && this.getDisk().equals(r.getDisk());
        }
        return false;
    }

    public double getCpu() {
        return this.cpu;
    }

    public ByteAmount getRam() {
        return this.ram;
    }

    public ByteAmount getDisk() {
        return this.disk;
    }

    public Resource cloneWithRam(ByteAmount newRam) {
        return new Resource(this.getCpu(), newRam, this.getDisk());
    }

    public Resource cloneWithCpu(double newCpu) {
        return new Resource(newCpu, this.getRam(), this.getDisk());
    }

    public Resource cloneWithDisk(ByteAmount newDisk) {
        return new Resource(this.getCpu(), this.getRam(), newDisk);
    }

    public Resource subtractAbsolute(Resource other) {
        double cpuDifference = this.getCpu() - other.getCpu();
        double extraCpu = Math.max(0.0, cpuDifference);
        ResourceMeasure ramDifference = this.getRam().minus((ResourceMeasure)other.getRam());
        ByteAmount extraRam = ByteAmount.ZERO.max((ByteAmount)ramDifference);
        ResourceMeasure diskDifference = this.getDisk().minus((ResourceMeasure)other.getDisk());
        ByteAmount extraDisk = ByteAmount.ZERO.max((ByteAmount)diskDifference);
        return new Resource(extraCpu, extraRam, extraDisk);
    }

    public Resource plus(Resource other) {
        double totalCpu = this.getCpu() + other.getCpu();
        ResourceMeasure totalRam = this.getRam().plus((ResourceMeasure)other.getRam());
        ResourceMeasure totalDisk = this.getDisk().plus((ResourceMeasure)other.getDisk());
        return new Resource(totalCpu, (ByteAmount)totalRam, (ByteAmount)totalDisk);
    }

    public double divideBy(Resource other) throws RuntimeException {
        if (other.getCpu() == 0.0 || other.getRam().isZero() || other.getDisk().isZero()) {
            throw new RuntimeException("Division by 0.");
        }
        double cpuFactor = Math.ceil(this.getCpu() / other.getCpu());
        double ramFactor = Math.ceil((double)this.getRam().asBytes() / (double)other.getRam().asBytes());
        double diskFactor = Math.ceil((double)this.getDisk().asBytes() / (double)other.getDisk().asBytes());
        return Math.max(cpuFactor, Math.max(ramFactor, diskFactor));
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.cpu);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + this.ram.hashCode();
        result = 31 * result + this.disk.hashCode();
        return result;
    }

    public String toString() {
        return String.format("{cpu: %f, ram: %s, disk: %s}", this.getCpu(), this.getRam(), this.getDisk());
    }
}

