/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.packing;

import org.apache.heron.proto.system.PackingPlans;
import org.apache.heron.spi.packing.PackingPlan;
import org.apache.heron.spi.packing.Resource;

public class PackingPlanProtoSerializer {
    public PackingPlans.PackingPlan toProto(PackingPlan packingPlan) {
        PackingPlans.PackingPlan.Builder builder = PackingPlans.PackingPlan.newBuilder().setId(packingPlan.getId());
        for (PackingPlan.ContainerPlan containerPlan : packingPlan.getContainers()) {
            builder.addContainerPlans(this.builder(containerPlan));
        }
        return builder.build();
    }

    private PackingPlans.ContainerPlan.Builder builder(PackingPlan.ContainerPlan containerPlan) {
        PackingPlans.ContainerPlan.Builder builder = PackingPlans.ContainerPlan.newBuilder().setId(containerPlan.getId()).setRequiredResource(this.builder(containerPlan.getRequiredResource()));
        if (containerPlan.getScheduledResource().isPresent()) {
            builder.setScheduledResource(this.builder(containerPlan.getScheduledResource().get()));
        }
        for (PackingPlan.InstancePlan instancePlan : containerPlan.getInstances()) {
            builder.addInstancePlans(this.builder(instancePlan));
        }
        return builder;
    }

    private PackingPlans.InstancePlan.Builder builder(PackingPlan.InstancePlan instancePlan) {
        return PackingPlans.InstancePlan.newBuilder().setComponentName(instancePlan.getComponentName()).setTaskId(instancePlan.getTaskId()).setComponentIndex(instancePlan.getComponentIndex()).setResource(this.builder(instancePlan.getResource()));
    }

    private PackingPlans.Resource.Builder builder(Resource resource) {
        return PackingPlans.Resource.newBuilder().setCpu(resource.getCpu()).setRam(resource.getRam().asBytes()).setDisk(resource.getDisk().asBytes());
    }
}

