/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.packing;

import java.util.HashSet;
import org.apache.heron.common.basics.ByteAmount;
import org.apache.heron.proto.system.PackingPlans;
import org.apache.heron.spi.packing.InstanceId;
import org.apache.heron.spi.packing.PackingPlan;
import org.apache.heron.spi.packing.Resource;

public class PackingPlanProtoDeserializer {
    public PackingPlan fromProto(PackingPlans.PackingPlan packingPlan) {
        HashSet<PackingPlan.ContainerPlan> containers = new HashSet<PackingPlan.ContainerPlan>();
        for (PackingPlans.ContainerPlan containerPlan : packingPlan.getContainerPlansList()) {
            containers.add(this.convert(containerPlan));
        }
        return new PackingPlan(packingPlan.getId(), containers);
    }

    private PackingPlan.ContainerPlan convert(PackingPlans.ContainerPlan containerPlan) {
        HashSet<PackingPlan.InstancePlan> instances = new HashSet<PackingPlan.InstancePlan>();
        for (PackingPlans.InstancePlan instancePlan : containerPlan.getInstancePlansList()) {
            instances.add(this.convert(instancePlan));
        }
        return new PackingPlan.ContainerPlan(containerPlan.getId(), instances, this.convert(containerPlan.getRequiredResource()), this.convert(containerPlan.getScheduledResource()));
    }

    private PackingPlan.InstancePlan convert(PackingPlans.InstancePlan instancePlan) {
        return new PackingPlan.InstancePlan(new InstanceId(instancePlan.getComponentName(), instancePlan.getTaskId(), instancePlan.getComponentIndex()), this.convert(instancePlan.getResource()));
    }

    private Resource convert(PackingPlans.Resource resource) {
        Resource result = null;
        if (resource != null && resource.isInitialized()) {
            result = new Resource(resource.getCpu(), ByteAmount.fromBytes(resource.getRam()), ByteAmount.fromBytes(resource.getDisk()));
        }
        return result;
    }
}

