/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.packing;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.heron.common.basics.ByteAmount;
import org.apache.heron.spi.packing.InstanceId;
import org.apache.heron.spi.packing.Resource;

public class PackingPlan {
    private final String id;
    private final Map<Integer, ContainerPlan> containersMap;
    private final Set<ContainerPlan> containers;

    public PackingPlan(String id, Set<ContainerPlan> containers) {
        this.id = id;
        this.containers = ImmutableSet.copyOf(containers);
        this.containersMap = new HashMap<Integer, ContainerPlan>();
        for (ContainerPlan containerPlan : containers) {
            this.containersMap.put(containerPlan.getId(), containerPlan);
        }
    }

    public Resource getMaxContainerResources() {
        double maxCpu = 0.0;
        ByteAmount maxRam = ByteAmount.ZERO;
        ByteAmount maxDisk = ByteAmount.ZERO;
        for (ContainerPlan containerPlan : this.getContainers()) {
            Resource containerResource = containerPlan.getScheduledResource().or(containerPlan.getRequiredResource());
            maxCpu = Math.max(maxCpu, containerResource.getCpu());
            maxRam = maxRam.max(containerResource.getRam());
            maxDisk = maxDisk.max(containerResource.getDisk());
        }
        return new Resource(maxCpu, maxRam, maxDisk);
    }

    public PackingPlan cloneWithHomogeneousScheduledResource() {
        Resource maxResource = this.getMaxContainerResources();
        LinkedHashSet<ContainerPlan> updatedContainers = new LinkedHashSet<ContainerPlan>();
        for (ContainerPlan container : this.getContainers()) {
            updatedContainers.add(container.cloneWithScheduledResource(maxResource));
        }
        return new PackingPlan(this.getId(), updatedContainers);
    }

    public String getId() {
        return this.id;
    }

    public Set<ContainerPlan> getContainers() {
        return this.containers;
    }

    public Map<Integer, ContainerPlan> getContainersMap() {
        return this.containersMap;
    }

    public Optional<ContainerPlan> getContainer(int containerId) {
        return Optional.fromNullable(this.containersMap.get(containerId));
    }

    public Integer getInstanceCount() {
        Integer totalInstances = 0;
        for (Integer count : this.getComponentCounts().values()) {
            totalInstances = totalInstances + count;
        }
        return totalInstances;
    }

    public Map<String, Integer> getComponentCounts() {
        HashMap<String, Integer> componentCounts = new HashMap<String, Integer>();
        for (ContainerPlan containerPlan : this.getContainers()) {
            for (InstancePlan instancePlan : containerPlan.getInstances()) {
                Integer count = 0;
                if (componentCounts.containsKey(instancePlan.getComponentName())) {
                    count = (Integer)componentCounts.get(instancePlan.getComponentName());
                }
                count = count + 1;
                componentCounts.put(instancePlan.getComponentName(), count);
            }
        }
        return componentCounts;
    }

    public String getComponentRamDistribution() {
        HashMap<String, ByteAmount> ramMap = new HashMap<String, ByteAmount>();
        for (ContainerPlan containerPlan : this.getContainers()) {
            for (InstancePlan instancePlan : containerPlan.getInstances()) {
                ByteAmount newRam = instancePlan.getResource().getRam();
                ByteAmount currentRam = (ByteAmount)ramMap.get(instancePlan.getComponentName());
                if (currentRam != null && currentRam.asBytes() <= newRam.asBytes()) continue;
                ramMap.put(instancePlan.getComponentName(), newRam);
            }
        }
        StringBuilder ramMapBuilder = new StringBuilder();
        for (String component : ramMap.keySet()) {
            ramMapBuilder.append(String.format("%s:%d,", component, ((ByteAmount)ramMap.get(component)).asBytes()));
        }
        ramMapBuilder.deleteCharAt(ramMapBuilder.length() - 1);
        return ramMapBuilder.toString();
    }

    public String toString() {
        return String.format("{plan-id: %s, containers-list: %s}", this.getId(), this.getContainers().toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackingPlan that = (PackingPlan)o;
        return this.getId().equals(that.getId()) && this.getContainers().equals(that.getContainers());
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = 31 * result + this.getContainers().hashCode();
        return result;
    }

    public static class ContainerPlan {
        private final int id;
        private final Set<InstancePlan> instances;
        private final Resource requiredResource;
        private final Optional<Resource> scheduledResource;

        public ContainerPlan(int id, Set<InstancePlan> instances, Resource requiredResource) {
            this(id, instances, requiredResource, null);
        }

        public ContainerPlan(int id, Set<InstancePlan> instances, Resource requiredResource, Resource scheduledResource) {
            this.id = id;
            this.instances = ImmutableSet.copyOf(instances);
            this.requiredResource = requiredResource;
            this.scheduledResource = Optional.fromNullable(scheduledResource);
        }

        public int getId() {
            return this.id;
        }

        public Set<InstancePlan> getInstances() {
            return this.instances;
        }

        public Resource getRequiredResource() {
            return this.requiredResource;
        }

        public Optional<Resource> getScheduledResource() {
            return this.scheduledResource;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContainerPlan that = (ContainerPlan)o;
            return this.id == that.id && this.getInstances().equals(that.getInstances()) && this.getRequiredResource().equals(that.getRequiredResource()) && this.getScheduledResource().equals(that.getScheduledResource());
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + this.getInstances().hashCode();
            result = 31 * result + this.getRequiredResource().hashCode();
            if (this.scheduledResource.isPresent()) {
                result = 31 * result + this.getScheduledResource().get().hashCode();
            }
            return result;
        }

        private ContainerPlan cloneWithScheduledResource(Resource resource) {
            return new ContainerPlan(this.getId(), this.getInstances(), this.getRequiredResource(), resource);
        }

        public String toString() {
            String str = String.format("{container-id: %s, instances-list: %s, required-resource: %s", this.id, this.getInstances().toString(), this.getRequiredResource());
            if (this.scheduledResource.isPresent()) {
                str = String.format("%s, scheduled-resource: %s", str, this.getScheduledResource().get());
            }
            return str + "}";
        }
    }

    public static class InstancePlan {
        private final String componentName;
        private final int taskId;
        private final int componentIndex;
        private final Resource resource;

        public InstancePlan(InstanceId instanceId, Resource resource) {
            this.componentName = instanceId.getComponentName();
            this.taskId = instanceId.getTaskId();
            this.componentIndex = instanceId.getComponentIndex();
            this.resource = resource;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public int getTaskId() {
            return this.taskId;
        }

        public int getComponentIndex() {
            return this.componentIndex;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstancePlan that = (InstancePlan)o;
            return this.getComponentName().equals(that.getComponentName()) && this.getTaskId() == that.getTaskId() && this.getComponentIndex() == that.getComponentIndex() && this.getResource().equals(that.getResource());
        }

        public int hashCode() {
            int result = this.getComponentName().hashCode();
            result = 31 * result + Integer.valueOf(this.getTaskId()).hashCode();
            result = 31 * result + Integer.valueOf(this.getComponentIndex()).hashCode();
            result = 31 * result + this.getResource().hashCode();
            return result;
        }

        public String toString() {
            return String.format("{component-name: %s, task-id: %s, component-index: %s, instance-resource: %s}", this.getComponentName(), this.getTaskId(), this.getComponentIndex(), this.getResource().toString());
        }
    }
}

