/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.metricsmgr.metrics;

import java.util.HashMap;
import java.util.LinkedList;
import org.apache.heron.spi.metricsmgr.metrics.ExceptionInfo;
import org.apache.heron.spi.metricsmgr.metrics.MetricsInfo;

public class MetricsRecord {
    private static final String DEFAULT_CONTEXT = "default";
    private final long timestamp;
    private final String source;
    private final Iterable<MetricsInfo> metrics;
    private final Iterable<ExceptionInfo> exceptions;
    private final String context;

    public MetricsRecord(String source, Iterable<MetricsInfo> metrics, Iterable<ExceptionInfo> exceptions) {
        this(source, metrics, exceptions, DEFAULT_CONTEXT);
    }

    public MetricsRecord(String source, Iterable<MetricsInfo> metrics, Iterable<ExceptionInfo> exceptions, String context) {
        this(System.currentTimeMillis(), source, metrics, exceptions, context);
    }

    public MetricsRecord(long timestamp, String source, Iterable<MetricsInfo> metrics, Iterable<ExceptionInfo> exceptions, String context) {
        this.source = source;
        this.timestamp = timestamp;
        this.context = context;
        this.metrics = metrics;
        this.exceptions = exceptions;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getSource() {
        return this.source;
    }

    public Iterable<MetricsInfo> getMetrics() {
        return this.metrics;
    }

    public Iterable<ExceptionInfo> getExceptions() {
        return this.exceptions;
    }

    public String getContext() {
        return this.context;
    }

    public String toString() {
        HashMap<String, String> metricsMap = new HashMap<String, String>();
        for (MetricsInfo metricsInfo : this.getMetrics()) {
            metricsMap.put(metricsInfo.getName(), metricsInfo.getValue());
        }
        LinkedList exceptionsList = new LinkedList();
        for (ExceptionInfo exceptionInfo : this.getExceptions()) {
            HashMap<String, Object> exception = new HashMap<String, Object>();
            exception.put("firstTime", exceptionInfo.getFirstTime());
            exception.put("lastTime", exceptionInfo.getLastTime());
            exception.put("logging", exceptionInfo.getLogging());
            exception.put("stackTrace", exceptionInfo.getStackTrace());
            exception.put("count", exceptionInfo.getCount());
            exceptionsList.add(exception);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timestamp", this.getTimestamp());
        hashMap.put("source", this.getSource());
        hashMap.put("context", this.getContext());
        hashMap.put("metrics", metricsMap);
        hashMap.put("exceptions", exceptionsList);
        return ((Object)hashMap).toString();
    }
}

