/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.metricsmgr.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.heron.spi.metricsmgr.metrics.MetricsInfo;

public class MetricsFilter {
    private final Map<String, MetricAggregationType> prefixToType = new HashMap<String, MetricAggregationType>();

    public void setPrefixToType(String prefix, MetricAggregationType type) {
        this.prefixToType.put(prefix, type);
    }

    public void setMetricToType(String metricName, MetricAggregationType type) {
        this.setPrefixToType(metricName, type);
    }

    public Set<String> getMetricNames() {
        return this.prefixToType.keySet();
    }

    public boolean contains(String metricName) {
        for (String prefix : this.prefixToType.keySet()) {
            if (!metricName.contains(prefix)) continue;
            return true;
        }
        return false;
    }

    public Iterable<MetricsInfo> filter(Iterable<MetricsInfo> metricsInfos) {
        ArrayList<MetricsInfo> metricsFiltered = new ArrayList<MetricsInfo>();
        for (MetricsInfo metricsInfo : metricsInfos) {
            if (!this.contains(metricsInfo.getName())) continue;
            metricsFiltered.add(metricsInfo);
        }
        return metricsFiltered;
    }

    public MetricAggregationType getAggregationType(String metricName) {
        for (String prefix : this.prefixToType.keySet()) {
            if (!metricName.contains(prefix)) continue;
            return this.prefixToType.get(prefix);
        }
        return MetricAggregationType.UNKNOWN;
    }

    public static enum MetricAggregationType {
        UNKNOWN,
        SUM,
        AVG,
        LAST;

    }
}

