/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.common;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.heron.spi.common.Config;
import org.apache.heron.spi.common.Key;

public final class TokenSub {
    private static final Logger LOG = Logger.getLogger(TokenSub.class.getName());
    private static final Pattern URL_PATTERN = Pattern.compile("(.+)://(.+)");
    private static final Pattern TOKEN_PATTERN = Pattern.compile("^\\$\\{([A-Z_]+)}$");

    private TokenSub() {
    }

    public static String substitute(Config config, String pathString) {
        String trimmedPath = pathString.trim();
        if (TokenSub.isURL(trimmedPath)) {
            return TokenSub.substituteURL(config, trimmedPath);
        }
        String fileSeparator = Matcher.quoteReplacement(File.separator);
        List<String> fixedList = Arrays.asList(trimmedPath.split(fileSeparator));
        LinkedList<String> list = new LinkedList<String>(fixedList);
        for (int i = 0; i < list.size(); ++i) {
            Matcher m;
            String elem = (String)list.get(i);
            if ("${HOME}".equals(elem) || "~".equals(elem)) {
                list.set(i, System.getProperty("user.home"));
                continue;
            }
            if ("${JAVA_HOME}".equals(elem)) {
                String javaPath = System.getenv("JAVA_HOME");
                if (javaPath == null) continue;
                list.set(i, javaPath);
                continue;
            }
            if (!TokenSub.isToken(elem) || !(m = TOKEN_PATTERN.matcher(elem)).matches()) continue;
            String token = m.group(1);
            try {
                Key key;
                String value;
                if ("TOPOLOGY".equals(token)) {
                    token = "TOPOLOGY_NAME";
                }
                if ((value = config.getStringValue(key = Key.valueOf(token))) == null) {
                    throw new IllegalArgumentException(String.format("Config value %s contains substitution token %s but the corresponding config setting %s not found", pathString, elem, key.value()));
                }
                list.set(i, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOG.fine(String.format("Config value %s contains substitution token %s which is not defined in the Key enum, which is required for token substitution", pathString, elem));
            }
        }
        return TokenSub.combinePaths(list);
    }

    @VisibleForTesting
    static boolean isURL(String pathString) {
        return URL_PATTERN.matcher(pathString).matches();
    }

    private static String substituteURL(Config config, String pathString) {
        Matcher m = URL_PATTERN.matcher(pathString);
        if (m.matches()) {
            return String.format("%s://%s", m.group(1), TokenSub.substitute(config, m.group(2)));
        }
        return pathString;
    }

    @VisibleForTesting
    static boolean isToken(String pathString) {
        Matcher m = TOKEN_PATTERN.matcher(pathString);
        return m.matches() && m.groupCount() > 0;
    }

    private static String combinePaths(List<String> paths) {
        File file = new File(paths.get(0));
        for (int i = 1; i < paths.size(); ++i) {
            file = new File(file, paths.get(i));
        }
        return file.getPath();
    }
}

