/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.common;

import org.apache.heron.common.basics.ByteAmount;

public enum Key {
    HERON_HOME("heron.directory.home", "/usr/local/heron"),
    HERON_BIN("heron.directory.bin", "${HERON_HOME}/bin"),
    HERON_CONF("heron.directory.conf", "${HERON_HOME}/conf"),
    HERON_LIB("heron.directory.lib", "${HERON_HOME}/lib"),
    HERON_DIST("heron.directory.dist", "${HERON_HOME}/dist"),
    HERON_ETC("heron.directory.etc", "${HERON_HOME}/etc"),
    JAVA_HOME("heron.directory.java.home", "${JAVA_HOME}"),
    CLUSTER_YAML("heron.config.file.cluster.yaml", "${HERON_CONF}/cluster.yaml"),
    CLIENT_YAML("heron.config.file.client.yaml", "${HERON_CONF}/client.yaml"),
    HEALTHMGR_YAML("heron.config.file.healthmgr.yaml", "${HERON_CONF}/healthmgr.yaml"),
    METRICS_YAML("heron.config.file.metrics.yaml", "${HERON_CONF}/metrics_sinks.yaml"),
    PACKING_YAML("heron.config.file.packing.yaml", "${HERON_CONF}/packing.yaml"),
    SCHEDULER_YAML("heron.config.file.scheduler.yaml", "${HERON_CONF}/scheduler.yaml"),
    STATEMGR_YAML("heron.config.file.statemgr.yaml", "${HERON_CONF}/statemgr.yaml"),
    SYSTEM_YAML("heron.config.file.system.yaml", "${HERON_CONF}/heron_internals.yaml"),
    UPLOADER_YAML("heron.config.file.uploader.yaml", "${HERON_CONF}/uploader.yaml"),
    DOWNLOADER_YAML("heron.config.file.downloader.yaml", "${HERON_CONF}/downloader.yaml"),
    STATEFUL_YAML("heron.config.file.stateful.yaml", "${HERON_CONF}/stateful.yaml"),
    CLUSTER("heron.config.cluster", Type.STRING),
    ROLE("heron.config.role", Type.STRING),
    ENVIRON("heron.config.environ", Type.STRING),
    SUBMIT_USER("heron.config.submit_user", Type.STRING),
    DRY_RUN("heron.config.dry_run", Boolean.FALSE),
    DRY_RUN_FORMAT_TYPE("heron.config.dry_run_format_type", Type.DRY_RUN_FORMAT_TYPE),
    VERBOSE("heron.config.verbose", Boolean.FALSE),
    VERBOSE_GC("heron.config.verbose_gc", Boolean.FALSE),
    CONFIG_PROPERTY("heron.config.property", Type.STRING),
    BUILD_VERSION("heron.build.version", Type.STRING),
    BUILD_TIME("heron.build.time", Type.STRING),
    BUILD_TIMESTAMP("heron.build.timestamp", Type.STRING),
    BUILD_HOST("heron.build.host", Type.STRING),
    BUILD_USER("heron.build.user", Type.STRING),
    UPLOADER_CLASS("heron.class.uploader", Type.STRING),
    LAUNCHER_CLASS("heron.class.launcher", Type.STRING),
    SCHEDULER_CLASS("heron.class.scheduler", Type.STRING),
    PACKING_CLASS("heron.class.packing.algorithm", Type.STRING),
    REPACKING_CLASS("heron.class.repacking.algorithm", Type.STRING),
    STATE_MANAGER_CLASS("heron.class.state.manager", Type.STRING),
    AURORA_CONTROLLER_CLASS("heron.class.scheduler.aurora.controller.cli", Boolean.TRUE),
    SCHEDULER_IS_SERVICE("heron.scheduler.is.service", Boolean.TRUE),
    SCHEDULER_PROPERTIES("heron.scheduler.properties", Type.PROPERTIES),
    SCHEDULER_JAR("heron.jars.scheduler", "${HERON_LIB}/scheduler/heron-scheduler.jar"),
    INTERNALS_CONFIG_FILE("heron.internals.config.file", Type.STRING),
    CORE_PACKAGE_DIRECTORY("heron.package.core.directory", "${HERON_DIST}/heron-core"),
    CORE_PACKAGE_URI("heron.package.core.uri", "${HERON_DIST}/heron-core.tar.gz"),
    USE_CORE_PACKAGE_URI("heron.package.use_core_uri", Boolean.TRUE),
    TOPOLOGY_PACKAGE_URI("heron.package.topology.uri", Type.STRING),
    TOPOLOGY_ID("heron.topology.id", Type.STRING),
    TOPOLOGY_NAME("heron.topology.name", Type.STRING),
    TOPOLOGY_DEFINITION_FILE("heron.topology.definition.file", Type.STRING),
    TOPOLOGY_DEFINITION("heron.topology.definition", Type.STRING),
    TOPOLOGY_BINARY_FILE("heron.topology.binary.file", Type.STRING),
    TOPOLOGY_PACKAGE_FILE("heron.topology.package.file", Type.STRING),
    TOPOLOGY_PACKAGE_TYPE("heron.topology.package.type", Type.PACKAGE_TYPE),
    TOPOLOGY_CONTAINER_ID("heron.topology.container.id", Type.STRING),
    SCHEDULER_PROXY_CONNECTION_STRING("heron.proxy.connection.string", Type.STRING),
    SCHEDULER_PROXY_CONNECTION_TYPE("heron.proxy.connection.type", Type.STRING),
    STATEMGR_CONNECTION_STRING("heron.statemgr.connection.string", Type.STRING),
    STATEMGR_ROOT_PATH("heron.statemgr.root.path", Type.STRING),
    STMGR_RAM("heron.resources.stmgr.ram", ByteAmount.fromBytes(0x40000000L)),
    CKPTMGR_RAM("heron.resources.ckptmgr.ram", ByteAmount.fromBytes(0x40000000L)),
    METRICSMGR_RAM("heron.resources.metricsmgr.ram", ByteAmount.fromBytes(0x40000000L)),
    INSTANCE_RAM("heron.resources.instance.ram", ByteAmount.fromBytes(0x40000000L)),
    INSTANCE_CPU("heron.resources.instance.cpu", 1.0),
    INSTANCE_DISK("heron.resources.instance.disk", ByteAmount.fromBytes(0x40000000L)),
    STATEFUL_STORAGE_CLASSNAME("heron.statefulstorage.classname", Type.STRING),
    STATEFUL_STORAGE_CONF("heron.statefulstorage.config", Type.MAP),
    STATEFUL_STORAGE_CUSTOM_CLASSPATH("heron.statefulstorage.custom.classpath", Type.STRING),
    METRICSCACHEMGR_MODE("heron.topology.metricscachemgr.mode", "disabled"),
    HEALTHMGR_MODE("heron.topology.healthmgr.mode", Type.STRING),
    INSTANCE_CLASSPATH("heron.classpath.instance", "${HERON_LIB}/instance/*"),
    HEALTHMGR_CLASSPATH("heron.classpath.healthmgr", "${HERON_LIB}/healthmgr/*"),
    METRICSMGR_CLASSPATH("heron.classpath.metrics.manager", "${HERON_LIB}/metricsmgr/*"),
    METRICSCACHEMGR_CLASSPATH("heron.classpath.metricscache.manager", "${HERON_LIB}/metricscachemgr/*"),
    PACKING_CLASSPATH("heron.classpath.packing", "${HERON_LIB}/packing/*"),
    SCHEDULER_CLASSPATH("heron.classpath.scheduler", "${HERON_LIB}/scheduler/*"),
    STATEMGR_CLASSPATH("heron.classpath.statemgr", "${HERON_LIB}/statemgr/*"),
    UPLOADER_CLASSPATH("heron.classpath.uploader", "${HERON_LIB}/uploader/*"),
    CKPTMGR_CLASSPATH("heron.classpath.ckptmgr", "${HERON_LIB}/ckptmgr/*"),
    STATEFULSTORAGE_CLASSPATH("heron.classpath.statefulstorage", "${HERON_LIB}/statefulstorage/*"),
    TOPOLOGY_CLASSPATH("heron.runtime.topology.class.path", Type.STRING),
    SCHEDULER_STATE_MANAGER_ADAPTOR("heron.runtime.scheduler.state.manager.adaptor", Type.STRING),
    SCHEDULER_SHUTDOWN("heron.runtime.scheduler.shutdown", Type.STRING),
    PACKING_CLASS_INSTANCE("heron.runtime.packing.class.instance", Type.STRING),
    LAUNCHER_CLASS_INSTANCE("heron.runtime.launcher.class.instance", Type.STRING),
    COMPONENT_RAMMAP("heron.runtime.component.rammap", Type.STRING),
    COMPONENT_JVM_OPTS_IN_BASE64("heron.runtime.component.jvm.opts.in.base64", Type.STRING),
    INSTANCE_JVM_OPTS_IN_BASE64("heron.runtime.instance.jvm.opts.in.base64", Type.STRING),
    NUM_CONTAINERS("heron.runtime.num.containers", Type.INTEGER),
    DOWNLOADER_PROTOCOLS("heron.downloader.registry", Type.MAP),
    HERON_RELEASE_PACKAGE("heron.release.package", Type.STRING),
    HERON_RELEASE_PACKAGE_ROLE("heron.release.package.role", Type.STRING),
    HERON_RELEASE_PACKAGE_NAME("heron.release.package.name", Type.STRING),
    HERON_RELEASE_PACKAGE_VERSION("heron.release.package.version", Type.STRING),
    HERON_UPLOADER_VERSION("heron.uploader.version", Type.STRING),
    HERON_CLUSTER_HOME("heron.directory.cluster.home", "./heron-core"),
    HERON_CLUSTER_CONF("heron.directory.cluster.conf", "./heron-conf"),
    HERON_CLUSTER_JAVA_HOME("heron.directory.sandbox.java.home", "/usr/lib/jvm/default-java"),
    OVERRIDE_YAML("heron.config.file.override.yaml", "${HERON_CONF}/override.yaml"),
    APISERVER_OVERRIDE_YAML("heron.apiserver.file.override.yaml", Type.STRING),
    EXECUTOR_BINARY("heron.binaries.executor", "${HERON_BIN}/heron-executor"),
    STMGR_BINARY("heron.binaries.stmgr", "${HERON_BIN}/heron-stmgr"),
    TMANAGER_BINARY("heron.binaries.tmanager", "${HERON_BIN}/heron-tmanager"),
    SHELL_BINARY("heron.binaries.shell", "${HERON_BIN}/heron-shell"),
    PYTHON_INSTANCE_BINARY("heron.binaries.python.instance", "${HERON_BIN}/heron-python-instance"),
    CPP_INSTANCE_BINARY("heron.binaries.cpp.instance", "${HERON_BIN}/heron-cpp-instance"),
    DOWNLOADER_BINARY("heron.binaries.downloader", "${HERON_BIN}/heron-downloader"),
    DOWNLOADER_CONF("heron.binaries.downloader-conf", "${HERON_BIN}/heron-downloader-config"),
    UPDATE_PROMPT("heron.command.update.prompt", "disabled");

    private final String value;
    private final Object defaultValue;
    private final Type type;

    private Key(String value, Type type) {
        this.value = value;
        this.type = type;
        this.defaultValue = null;
    }

    private Key(String value, String defaultValue) {
        this.value = value;
        this.type = Type.STRING;
        this.defaultValue = defaultValue;
    }

    private Key(String value, Double defaultValue) {
        this.value = value;
        this.type = Type.DOUBLE;
        this.defaultValue = defaultValue;
    }

    private Key(String value, Boolean defaultValue) {
        this.value = value;
        this.type = Type.BOOLEAN;
        this.defaultValue = defaultValue;
    }

    private Key(String value, ByteAmount defaultValue) {
        this.value = value;
        this.type = Type.BYTE_AMOUNT;
        this.defaultValue = defaultValue;
    }

    public String value() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public String getDefaultString() {
        if (this.type != Type.STRING) {
            throw new IllegalAccessError(String.format("Config Key %s is type %s, getDefaultString() not supported", new Object[]{this.name(), this.type}));
        }
        return (String)this.defaultValue;
    }

    public static enum Type {
        BOOLEAN,
        BYTE_AMOUNT,
        DOUBLE,
        DRY_RUN_FORMAT_TYPE,
        INTEGER,
        LONG,
        STRING,
        PACKAGE_TYPE,
        PROPERTIES,
        MAP,
        UNKNOWN;

    }
}

