/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.common;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.heron.common.config.ConfigReader;
import org.apache.heron.spi.common.Config;
import org.apache.heron.spi.common.Context;
import org.apache.heron.spi.common.Key;

public final class ConfigLoader {
    private ConfigLoader() {
    }

    private static Config loadDefaults(String heronHome, String configPath) {
        return Config.newBuilder(true).put(Key.HERON_HOME, (Object)heronHome).put(Key.HERON_CONF, (Object)configPath).build();
    }

    @VisibleForTesting
    static Config loadConfig(String file) {
        Map<String, Object> readConfig = ConfigReader.loadFile(file);
        return ConfigLoader.addFromFile(readConfig);
    }

    @VisibleForTesting
    static Config addFromFile(Map<String, Object> readConfig) {
        return Config.newBuilder().putAll(readConfig).build();
    }

    public static Config loadConfig(String heronHome, String configPath, String releaseFile, String overrideConfigFile) {
        Config defaultConfig = ConfigLoader.loadDefaults(heronHome, configPath);
        Config localConfig = Config.toLocalMode(defaultConfig);
        Config.Builder cb = Config.newBuilder().putAll(defaultConfig).putAll(ConfigLoader.loadConfig(Context.clusterFile(localConfig))).putAll(ConfigLoader.loadConfig(Context.clientFile(localConfig))).putAll(ConfigLoader.loadConfig(Context.healthmgrFile(localConfig))).putAll(ConfigLoader.loadConfig(Context.packingFile(localConfig))).putAll(ConfigLoader.loadConfig(Context.schedulerFile(localConfig))).putAll(ConfigLoader.loadConfig(Context.stateManagerFile(localConfig))).putAll(ConfigLoader.loadConfig(Context.uploaderFile(localConfig))).putAll(ConfigLoader.loadConfig(Context.downloaderFile(localConfig))).putAll(ConfigLoader.loadConfig(Context.statefulConfigFile(localConfig))).putAll(ConfigLoader.loadConfig(releaseFile)).putAll(ConfigLoader.loadConfig(overrideConfigFile));
        return cb.build();
    }

    public static Config loadClusterConfig() {
        Config defaultConfig = ConfigLoader.loadDefaults(Key.HERON_CLUSTER_HOME.getDefaultString(), Key.HERON_CLUSTER_CONF.getDefaultString());
        Config clusterConfig = Config.toClusterMode(defaultConfig);
        Config.Builder cb = Config.newBuilder().putAll(defaultConfig).putAll(ConfigLoader.loadConfig(Context.packingFile(clusterConfig))).putAll(ConfigLoader.loadConfig(Context.healthmgrFile(clusterConfig))).putAll(ConfigLoader.loadConfig(Context.schedulerFile(clusterConfig))).putAll(ConfigLoader.loadConfig(Context.stateManagerFile(clusterConfig))).putAll(ConfigLoader.loadConfig(Context.uploaderFile(clusterConfig))).putAll(ConfigLoader.loadConfig(Context.downloaderFile(clusterConfig))).putAll(ConfigLoader.loadConfig(Context.statefulConfigFile(clusterConfig)));
        cb.putAll(ConfigLoader.loadConfig(Context.overrideFile(clusterConfig)));
        return cb.build();
    }
}

