/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.spi.common;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.heron.common.basics.ByteAmount;
import org.apache.heron.common.basics.DryRunFormatType;
import org.apache.heron.common.basics.PackageType;
import org.apache.heron.common.basics.TypeUtils;
import org.apache.heron.spi.common.Key;
import org.apache.heron.spi.common.TokenSub;

public class Config {
    private static final Logger LOG = Logger.getLogger(Config.class.getName());
    private final Map<String, Object> cfgMap;
    private final Mode mode;
    private final Config rawConfig;
    private Config localConfig = null;
    private Config clusterConfig = null;

    protected Config(Builder build) {
        this.mode = Mode.RAW;
        this.rawConfig = this;
        this.cfgMap = new HashMap<String, Object>(build.keyValues);
    }

    private Config(Mode mode, Config rawConfig, Config localConfig, Config clusterConfig) {
        this.mode = mode;
        this.rawConfig = rawConfig;
        this.localConfig = localConfig;
        this.clusterConfig = clusterConfig;
        switch (mode) {
            case RAW: {
                this.cfgMap = rawConfig.cfgMap;
                break;
            }
            case LOCAL: {
                this.cfgMap = localConfig.cfgMap;
                break;
            }
            case CLUSTER: {
                this.cfgMap = clusterConfig.cfgMap;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized mode passed to constructor: " + (Object)((Object)mode));
            }
        }
    }

    public static Builder newBuilder() {
        return Config.newBuilder(false);
    }

    public static Builder newBuilder(boolean loadDefaults) {
        return Builder.create(loadDefaults);
    }

    public static Config toLocalMode(Config config) {
        return config.lazyCreateConfig(Mode.LOCAL);
    }

    public static Config toClusterMode(Config config) {
        return config.lazyCreateConfig(Mode.CLUSTER);
    }

    private static Config expand(Config config) {
        return Config.expand(config, 0);
    }

    private static Config expand(Config config, int previousTokensCount) {
        Builder cb = Config.newBuilder().putAll(config);
        int tokensCount = 0;
        for (String key : config.getKeySet()) {
            Object value = config.get(key);
            if (value instanceof String) {
                String expandedValue = TokenSub.substitute(config, (String)value);
                if (expandedValue.contains("${")) {
                    ++tokensCount;
                }
                cb.put(key, (Object)expandedValue);
                continue;
            }
            cb.put(key, value);
        }
        if (previousTokensCount != tokensCount) {
            return Config.expand(cb.build(), tokensCount);
        }
        return cb.build();
    }

    private Config lazyCreateConfig(Mode newMode) {
        if (newMode == this.mode) {
            return this;
        }
        Config newRawConfig = this.rawConfig;
        Config newLocalConfig = this.localConfig;
        Config newClusterConfig = this.clusterConfig;
        switch (this.mode) {
            case RAW: {
                newRawConfig = this;
                break;
            }
            case LOCAL: {
                newLocalConfig = this;
                break;
            }
            case CLUSTER: {
                newClusterConfig = this;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized mode found in config: " + (Object)((Object)this.mode));
            }
        }
        switch (newMode) {
            case LOCAL: {
                if (this.localConfig == null) {
                    Config tempConfig = Config.expand(Config.newBuilder().putAll(this.rawConfig.cfgMap).build());
                    this.localConfig = new Config(Mode.LOCAL, newRawConfig, tempConfig, newClusterConfig);
                }
                return this.localConfig;
            }
            case CLUSTER: {
                if (this.clusterConfig == null) {
                    Builder bc = Config.newBuilder().putAll(this.rawConfig.cfgMap).put(Key.HERON_HOME, this.get(Key.HERON_CLUSTER_HOME)).put(Key.HERON_CONF, this.get(Key.HERON_CLUSTER_CONF));
                    Config tempConfig = Config.expand(bc.build());
                    this.clusterConfig = new Config(Mode.CLUSTER, newRawConfig, newLocalConfig, tempConfig);
                }
                return this.clusterConfig;
            }
        }
        throw new IllegalArgumentException("Unrecognized mode passed to lazyCreateConfig: " + (Object)((Object)newMode));
    }

    public int size() {
        return this.cfgMap.size();
    }

    public Object get(Key key) {
        return this.get(key.value());
    }

    private Object get(String key) {
        switch (this.mode) {
            case LOCAL: {
                return this.localConfig.cfgMap.get(key);
            }
            case CLUSTER: {
                return this.clusterConfig.cfgMap.get(key);
            }
            case RAW: {
                return this.rawConfig.cfgMap.get(key);
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized mode passed to get for key=%s: %s", new Object[]{key, this.mode}));
    }

    public String getStringValue(String key) {
        return (String)this.get(key);
    }

    public String getStringValue(Key key) {
        return (String)this.get(key);
    }

    public String getStringValue(String key, String defaultValue) {
        String value = this.getStringValue(key);
        return value != null ? value : defaultValue;
    }

    public Boolean getBooleanValue(Key key) {
        return (Boolean)this.get(key);
    }

    private Boolean getBooleanValue(String key) {
        return (Boolean)this.get(key);
    }

    public Boolean getBooleanValue(String key, boolean defaultValue) {
        Boolean value = this.getBooleanValue(key);
        return value != null ? value : defaultValue;
    }

    public ByteAmount getByteAmountValue(Key key) {
        Object value = this.get(key);
        return TypeUtils.getByteAmount(value);
    }

    DryRunFormatType getDryRunFormatType(Key key) {
        return (DryRunFormatType)((Object)this.get(key));
    }

    public PackageType getPackageType(Key key) {
        return (PackageType)((Object)this.get(key));
    }

    public Long getLongValue(Key key) {
        Object value = this.get(key);
        return TypeUtils.getLong(value);
    }

    public Long getLongValue(String key, long defaultValue) {
        Object value = this.get(key);
        if (value != null) {
            return TypeUtils.getLong(value);
        }
        return defaultValue;
    }

    public Integer getIntegerValue(Key key) {
        Object value = this.get(key);
        return TypeUtils.getInteger(value);
    }

    public Integer getIntegerValue(String key, int defaultValue) {
        Object value = this.get(key);
        if (value != null) {
            return TypeUtils.getInteger(value);
        }
        return defaultValue;
    }

    public Double getDoubleValue(Key key) {
        Object value = this.get(key);
        return TypeUtils.getDouble(value);
    }

    public Duration getDurationValue(String key, TemporalUnit unit, Duration defaultValue) {
        Object value = this.get(key);
        if (value != null) {
            return TypeUtils.getDuration(value, unit);
        }
        return defaultValue;
    }

    public boolean containsKey(Key key) {
        return this.cfgMap.containsKey(key.value());
    }

    public Set<String> getKeySet() {
        return this.cfgMap.keySet();
    }

    public Set<Map.Entry<String, Object>> getEntrySet() {
        return this.cfgMap.entrySet();
    }

    public String toString() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(this.cfgMap);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            sb.append("(\"").append((String)entry.getKey()).append("\"");
            sb.append(", ").append(entry.getValue()).append(")\n");
        }
        return sb.toString();
    }

    public static class Builder {
        private final Map<String, Object> keyValues = new HashMap<String, Object>();

        private static Builder create(boolean loadDefaults) {
            Builder cb = new Builder();
            if (loadDefaults) {
                Builder.loadDefaults(cb, Key.values());
            }
            return cb;
        }

        private static void loadDefaults(Builder cb, Key ... keys) {
            for (Key key : keys) {
                if (key.getDefault() == null) continue;
                cb.put(key, key.getDefault());
            }
        }

        public Builder put(String key, Object value) {
            this.keyValues.put(key, value);
            return this;
        }

        public Builder put(Key key, Object value) {
            this.put(key.value(), value);
            return this;
        }

        public Builder putAll(Config ctx) {
            this.keyValues.putAll(ctx.cfgMap);
            return this;
        }

        public Builder putAll(Map<String, Object> map) {
            this.keyValues.putAll(map);
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }

    private static enum Mode {
        RAW,
        LOCAL,
        CLUSTER;

    }
}

