/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.basics;

import java.time.Duration;
import org.apache.heron.common.basics.WakeableLooper;

public class ExecutorLooper
extends WakeableLooper {
    private final RunnableLock lock = new RunnableLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWait() {
        Object object = this.lock.proceedLock;
        synchronized (object) {
            Duration nextTimeoutInterval;
            while (!this.lock.isToProceed && (nextTimeoutInterval = this.getNextTimeoutInterval()).toMillis() > 0L) {
                try {
                    this.lock.isWaiting = true;
                    this.lock.proceedLock.wait(nextTimeoutInterval.toMillis());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    this.lock.isWaiting = false;
                }
            }
            this.lock.isToProceed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeUp() {
        if (!this.lock.isToProceed) {
            Object object = this.lock.proceedLock;
            synchronized (object) {
                this.lock.isToProceed = true;
                if (this.lock.isWaiting) {
                    this.lock.proceedLock.notify();
                }
            }
        }
    }

    private static final class RunnableLock {
        private Object proceedLock = new Object();
        private volatile boolean isToProceed = false;
        private volatile boolean isWaiting = false;

        RunnableLock() {
        }
    }
}

