/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.bolt;

import java.io.Serializable;
import org.apache.heron.api.bolt.IStatefulWindowedBolt;
import org.apache.heron.api.bolt.WindowedBoltExecutor;
import org.apache.heron.api.state.HashMapState;
import org.apache.heron.api.state.State;

public class StatefulWindowedBoltExecutor<K extends Serializable, V extends Serializable>
extends WindowedBoltExecutor {
    private static final long serialVersionUID = 4975915597473064341L;
    private final IStatefulWindowedBolt statefulWindowedBolt;
    private State state;
    private static final String USER_STATE = "user.state";

    public StatefulWindowedBoltExecutor(IStatefulWindowedBolt bolt) {
        super(bolt);
        this.statefulWindowedBolt = bolt;
    }

    @Override
    public void initState(State state) {
        this.state = state;
        super.initState(this.state);
        if (!this.state.containsKey(USER_STATE)) {
            this.state.put(USER_STATE, new HashMapState());
        }
        this.statefulWindowedBolt.initState((State)this.state.get(USER_STATE));
    }

    @Override
    public void preSave(String checkpointId) {
        this.statefulWindowedBolt.preSave(checkpointId);
        super.preSave(checkpointId);
    }
}

