#  Licensed to the Apache Software Foundation (ASF) under one
#  or more contributor license agreements.  See the NOTICE file
#  distributed with this work for additional information
#  regarding copyright ownership.  The ASF licenses this file
#  to you under the Apache License, Version 2.0 (the
#  "License"); you may not use this file except in compliance
#  with the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing,
#  software distributed under the License is distributed on an
#  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#  KIND, either express or implied.  See the License for the
#  specific language governing permissions and limitations
#  under the License.

"""heron setuptools based setup module"""
import os, re, sys
from setuptools import setup, find_packages

package_name = "heronpy"
release_version = "0.20.5rc4"

# read the requirements file
here = os.path.abspath(os.path.dirname(__file__))
requirement_file = os.path.join(here, 'requirements.txt')
with open(requirement_file, 'r') as f:
  raw_requirements = f.read().strip()

requirements = raw_requirements.split('\n')
print("Requirements: %s" % requirements)

long_description = "The heronpy package enables you to write Heron topologies in Python. " \
                   "Topologies can be run using a variety of schedulers, including Mesos/Aurora," \
                   "Kubernetes, Mesos/Marathon, YARN, etc."

setup(
  name=package_name,
  version=release_version,
  description='Python Topology API for Heron',
  long_description=long_description,

  url='https://github.com/apache/incubator-heron',

  author='Apache Heron (incubating)',
  author_email='dev@heron.apache.org',
  license='Apache License v2.0',
  classifiers=[
    'Development Status :: 3 - Alpha',

    'Intended Audience :: Developers',

    'Programming Language :: Python :: 3.4',
    'Programming Language :: Python :: 3.5',
    'Programming Language :: Python :: 3.6',
    'Programming Language :: Python :: 3.7',
    'Programming Language :: Python :: 3.8',
  ],

  keywords='heron streaming analytics topology python',
  packages=find_packages(),

  install_requires=requirements,
  python_requires='~=3.4',
)
