---
id: version-0.20.4-incubating-heron-resources-resources
title: Heron Resources
sidebar_label: Heron Resources
original_id: heron-resources-resources
---
<!--
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at
      http://www.apache.org/licenses/LICENSE-2.0
    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->

Heron Resources outside this documentation:

## Books

* [Heron Streaming: Fundamentals, Applications, Operations, and Insights](https://www.springer.com/us/book/9783030600938)

## Conference & Journal Papers

* [Streaming@Twitter - Bulletin of the IEEE Computer Society Technical Committee on Data Engineering](http://sites.computer.org/debull/A15dec/p15.pdf) (Jul, 2016)
* [Twitter Heron: Stream Processing at
  Scale - SIGMOD’15](http://dl.acm.org/citation.cfm?id=2742788) (May, 2015)
* [Storm@Twitter - SIGMOD'14](http://dl.acm.org/citation.cfm?id=2595641) (Jun, 2014)

## Videos

* [Twitter Heron on Apache Aurora - #compute event @Twitter](https://m.youtube.com/watch?v=ua0ufmr9sQI&feature=youtu.be) (Apr, 2016)
* [Flying Faster with Heron - InfoQ](http://www.infoq.com/presentations/twitter-heron) (Apr, 2016)
* [Twitter Heron: Stream Processing at
  Scale - @Scale](https://www.youtube.com/watch?v=pUaFOuGgmco) (Sep, 2015)
* [Stream Processing and Anomaly Detection - Velocity O'Reilly - Note: requires O'Reilly login ](
https://player.oreilly.com/videos/9781491927977?login=true)(Jun, 2015)
* [Building Apache Heron - BazelCon 2018](https://www.youtube.com/watch?v=yBTSfA4YDtY&t=1s)(Oct, 2018)

##  Blog Posts
* [Leaving the Nest: Heron donated to Apache Software Foundation](https://blog.twitter.com/engineering/en_us/topics/open-source/2018/heron-donated-to-apache-software-foundation.html) (Feb, 2018)
* [Open Sourcing Twitter Heron](https://blog.twitter.com/2016/open-sourcing-twitter-heron) (May, 2016)
* [Flying Faster with Twitter
  Heron](https://blog.twitter.com/2015/flying-faster-with-twitter-heron) (June, 2015)
* [Deploying Heron on a Cluster of Machines with Apache Aurora](http://streamanalytics.blogspot.com/2016/06/deploying-heron-on-cluster-of-machines.html) (Supun Kamburugamuve, Jun, 2016)
* [Setting up Heron Locally with Apache Aurora](http://pulasthisupun.blogspot.com/2016/06/setting-up-heron-cluster-with-apache.html) (Pulasthi Supun, Jun, 2016)
* [Introducing Heron’s ECO; A Flexible Way To Manage Topologies](https://1904labs.com/2018/02/14/introducing-herons-eco-flexible-way-manage-topologies/) (Feb, 2018)

## Slides

* [Real-Time Analytics: Algorithms and Systems - Twitter University ](
http://www.slideshare.net/arunkejariwal/real-time-analytics-algorithms-and-systems) (May, 2016)
* [Stream Processing and Anomaly Detection - Velocity O'Reilly ](http://www.slideshare.net/arunkejariwal/velocity-2015final)(Jun, 2015)

## Press 

* [Heron, Twitter's Data Streaming Platform, Has Been Open Sourced](http://www.benzinga.com/tech/16/06/8119962/heron-twitters-data-streaming-platform-has-been-open-sourced) (BenZinga, Jun, 2016)
* [Twitter Open Sources Heron -- Data Streaming For Dummies](http://www.forbes.com/sites/adrianbridgwater/2016/06/16/twitter-open-sources-heron-data-streaming-for-dummies/#6f8984319b50) (Forbes, Jun, 2016)
* [Getting Started with Heron on Apache Mesos and Apache Kafka](https://allthingshadoop.com/2016/05/30/getting-started-with-heron-on-apache-mesos-and-apache-kafka/) (All Things Hadoop, May, 2016)
* [Twitter open-sources Heron, its real-time stream-processing engine](http://venturebeat.com/2016/05/25/twitter-open-sources-heron-its-real-time-stream-processing-engine/) (VentureBeat, May, 2016)
* [Twitter's Heron Will Start a New Chapter in Real-Time Streaming](http://www.forbes.com/sites/janakirammsv/2015/06/08/twitters-heron-will-start-a-new-chapter-in-real-time-streaming/#62c8645b2306) (Forbes, Jun, 2015)
* [Twitter Has Replaced Storm with Heron](https://www.infoq.com/news/2015/06/twitter-storm-heron) (InfoQ, Jun, 2015)