/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.heron.api.bolt;

import java.util.Map;

import org.apache.heron.api.topology.IComponent;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Tuple;

public interface IBasicBolt extends IComponent {
  void prepare(Map<String, Object> heronConf, TopologyContext context);

  /**
   * Process the input tuple and optionally emit new tuples based on the input tuple.
   * <p>
   * All acking is managed for you. Throw a FailedException if you want to fail the tuple.
   */
  void execute(Tuple input, BasicOutputCollector collector);

  void cleanup();
}
