<!--
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->
[![Build Status](https://travis-ci.com/apache/incubator-heron.svg?&branch=master)](https://travis-ci.com/apache/incubator-heron)

![logo](website2/docs/assets/HeronTextLogo.png)

Heron is a realtime analytics platform developed by Twitter.  It has a wide array of architectural improvements over it's predecessor.

[Heron in Apache Incubation](http://incubator.apache.org/projects/heron.html)

### Documentation

[https://heron.incubator.apache.org/](https://heron.apache.org/)
</br>
Confluence: https://cwiki.apache.org/confluence/display/HERON

#### Heron Requirements:
 * Java 11
 * Python 3.6
 * Bazel 4.2.2

## Contact

#### Mailing lists

| Name                                                                      | Scope                           |                                                                |                                                                    |                                                                           |
|:--------------------------------------------------------------------------|:--------------------------------|:---------------------------------------------------------------|:-------------------------------------------------------------------|:--------------------------------------------------------------------------|
| [user@heron.incubator.apache.org](mailto:user@heron.incubator.apache.org) | User-related discussions        | [Subscribe](mailto:user-subscribe@heron.incubator.apache.org)  | [Unsubscribe](mailto:user-unsubscribe@heron.incubator.apache.org)  | [Archives](http://mail-archives.apache.org/mod_mbox/incubator-heron-user/)|
| [dev@heron.incubator.apache.org](mailto:dev@heron.incubator.apache.org)   | Development-related discussions | [Subscribe](mailto:dev-subscribe@heron.incubator.apache.org)   | [Unsubscribe](mailto:dev-unsubscribe@heron.incubator.apache.org)   | [Archives](http://mail-archives.apache.org/mod_mbox/incubator-heron-dev/) |

#### Slack

[Self-Register](http://heronstreaming.herokuapp.com/) to our [Heron Slack Workspace](https://heronstreaming.slack.com/)

#### Meetup Group

[Bay Area Heron Meetup](https://www.meetup.com/Apache-Heron-Bay-Area), *We meet on Third Monday of Every Month in Palo Alto.*

## For more information:

* Official Heron documentation located at [https://heron.apache.org/](https://heron.apache.org/)
* Official Heron resources, including Conference & Journal Papers, Videos, Blog Posts and selected Press located at [Heron Resources](https://heron.apache.org/resources)
* [Twitter Heron: Stream Processing at Scale](http://dl.acm.org/citation.cfm?id=2742788) (academic paper)
* [Twitter Heron: Stream Processing at Scale](https://www.youtube.com/watch?v=pUaFOuGgmco) (YouTube video)
* [Flying Faster with Twitter Heron](https://blog.twitter.com/2015/flying-faster-with-twitter-heron) (blog post)

## License

Licensed under the Apache License, Version 2.0: http://www.apache.org/licenses/LICENSE-2.0
