/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.meta.ModelVersionEntity;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionAliasRelMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionMetaMapper;
import org.apache.gravitino.storage.relational.po.ModelVersionAliasRelPO;
import org.apache.gravitino.storage.relational.po.ModelVersionPO;
import org.apache.gravitino.storage.relational.service.CommonMetaService;
import org.apache.gravitino.storage.relational.service.ModelMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.glassfish.jersey.internal.guava.Lists;
import org.glassfish.jersey.internal.guava.Preconditions;

public class ModelVersionMetaService {
    private static final ModelVersionMetaService INSTANCE = new ModelVersionMetaService();

    public static ModelVersionMetaService getInstance() {
        return INSTANCE;
    }

    private ModelVersionMetaService() {
    }

    public List<ModelVersionEntity> listModelVersionsByNamespace(Namespace ns) {
        NamespaceUtil.checkModelVersion(ns);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ns.levels());
        ModelEntity modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        List modelVersionPOs = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.listModelVersionMetasByModelId(modelEntity.id()));
        if (modelVersionPOs.isEmpty()) {
            return Collections.emptyList();
        }
        List aliasRelPOs = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.selectModelVersionAliasRelsByModelId(modelEntity.id()));
        ArrayListMultimap aliasRelPOsByModelVersion = ArrayListMultimap.create();
        aliasRelPOs.forEach(arg_0 -> ModelVersionMetaService.lambda$listModelVersionsByNamespace$2((Multimap)aliasRelPOsByModelVersion, arg_0));
        return modelVersionPOs.stream().map(arg_0 -> ModelVersionMetaService.lambda$listModelVersionsByNamespace$3((Multimap)aliasRelPOsByModelVersion, modelIdent, arg_0)).collect(Collectors.toList());
    }

    public ModelVersionEntity getModelVersionByIdentifier(NameIdentifier ident) {
        NameIdentifierUtil.checkModelVersion(ident);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ident.namespace().levels());
        ModelEntity modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        boolean isVersionNumber = NumberUtils.isCreatable((String)ident.name());
        ModelVersionPO modelVersionPO = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionMeta(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionMetaByAlias(modelEntity.id(), ident.name());
        });
        if (modelVersionPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL_VERSION.name().toLowerCase(Locale.ROOT), ident.toString()});
        }
        List aliasRelPOs = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionAliasRelsByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), ident.name());
        });
        return POConverters.fromModelVersionPO(modelIdent, modelVersionPO, aliasRelPOs);
    }

    public void insertModelVersion(ModelVersionEntity modelVersionEntity) throws IOException {
        NameIdentifier modelIdent = modelVersionEntity.modelIdentifier();
        NameIdentifierUtil.checkModel(modelIdent);
        Long schemaId = CommonMetaService.getInstance().getParentEntityIdByNamespace(modelIdent.namespace());
        Long modelId = ModelMetaService.getInstance().getModelIdBySchemaIdAndModelName(schemaId, modelIdent.name());
        ModelVersionPO.Builder builder = ModelVersionPO.builder().withModelId(modelId);
        ModelVersionPO modelVersionPO = POConverters.initializeModelVersionPO(modelVersionEntity, builder);
        List<ModelVersionAliasRelPO> aliasRelPOs = POConverters.initializeModelVersionAliasRelPO(modelVersionEntity, modelId);
        try {
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.insertModelVersionMeta(modelVersionPO)), () -> {
                if (aliasRelPOs.isEmpty()) {
                    return;
                }
                SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.insertModelVersionAliasRels(aliasRelPOs));
            }, () -> SessionUtils.doWithoutCommit(ModelMetaMapper.class, mapper -> mapper.updateModelLatestVersion(modelId)));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.MODEL_VERSION, modelVersionEntity.modelIdentifier().toString());
            throw re;
        }
    }

    public boolean deleteModelVersion(NameIdentifier ident) {
        ModelEntity modelEntity;
        NameIdentifierUtil.checkModelVersion(ident);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ident.namespace().levels());
        try {
            modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        }
        catch (NoSuchEntityException e) {
            return false;
        }
        boolean isVersionNumber = NumberUtils.isCreatable((String)ident.name());
        AtomicInteger modelVersionDeletedCount = new AtomicInteger();
        SessionUtils.doMultipleWithCommit(() -> modelVersionDeletedCount.set(SessionUtils.doWithoutCommitAndFetchResult(ModelVersionMetaMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.softDeleteModelVersionMetaByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.softDeleteModelVersionMetaByModelIdAndAlias(modelEntity.id(), ident.name());
        })), () -> {
            if (modelVersionDeletedCount.get() == 0) {
                return;
            }
            SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> {
                if (isVersionNumber) {
                    mapper.softDeleteModelVersionAliasRelsByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
                } else {
                    mapper.softDeleteModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), ident.name());
                }
            });
        });
        return modelVersionDeletedCount.get() > 0;
    }

    public int deleteModelVersionMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        int[] modelVersionDeletedCount = new int[]{0};
        int[] modelVersionAliasRelDeletedCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            modelVersionDeletedCount[0] = SessionUtils.doWithoutCommitAndFetchResult(ModelVersionMetaMapper.class, mapper -> mapper.deleteModelVersionMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            modelVersionAliasRelDeletedCount[0] = SessionUtils.doWithoutCommitAndFetchResult(ModelVersionAliasRelMapper.class, mapper -> mapper.deleteModelVersionAliasRelsByLegacyTimeline(legacyTimeline, limit));
        });
        return modelVersionDeletedCount[0] + modelVersionAliasRelDeletedCount[0];
    }

    public <E extends Entity & HasIdentifier> ModelVersionEntity updateModelVersion(NameIdentifier ident, Function<E, E> updater) throws IOException {
        Integer updateResult;
        NameIdentifierUtil.checkModelVersion(ident);
        NameIdentifier modelIdent = NameIdentifier.of((String[])ident.namespace().levels());
        boolean isVersionNumber = NumberUtils.isCreatable((String)ident.name());
        ModelEntity modelEntity = ModelMetaService.getInstance().getModelByIdentifier(modelIdent);
        ModelVersionPO oldModelVersionPO = SessionUtils.getWithoutCommit(ModelVersionMetaMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionMeta(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionMetaByAlias(modelEntity.id(), ident.name());
        });
        if (oldModelVersionPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.MODEL_VERSION.name().toLowerCase(Locale.ROOT), ident.toString()});
        }
        List aliasRelPOs = SessionUtils.getWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> {
            if (isVersionNumber) {
                return mapper.selectModelVersionAliasRelsByModelIdAndVersion(modelEntity.id(), Integer.valueOf(ident.name()));
            }
            return mapper.selectModelVersionAliasRelsByModelIdAndAlias(modelEntity.id(), ident.name());
        });
        ModelVersionEntity oldModelVersionEntity = POConverters.fromModelVersionPO(modelIdent, oldModelVersionPO, aliasRelPOs);
        ModelVersionEntity newModelVersionEntity = (ModelVersionEntity)updater.apply(oldModelVersionEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldModelVersionEntity.version(), newModelVersionEntity.version()), (String)"The updated model version: %s should be same with the table entity version before: %s", (Object[])new Object[]{newModelVersionEntity.version(), oldModelVersionEntity.version()});
        try {
            updateResult = SessionUtils.doWithCommitAndFetchResult(ModelVersionMetaMapper.class, mapper -> mapper.updateModelVersionMeta(POConverters.updateModelVersionPO(oldModelVersionPO, newModelVersionEntity), oldModelVersionPO));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.CATALOG, newModelVersionEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newModelVersionEntity;
        }
        throw new IOException("Failed to update the entity: " + ident);
    }

    private static /* synthetic */ ModelVersionEntity lambda$listModelVersionsByNamespace$3(Multimap aliasRelPOsByModelVersion, NameIdentifier modelIdent, ModelVersionPO m) {
        ArrayList versionAliasRelPOs = Lists.newArrayList((Iterable)aliasRelPOsByModelVersion.get((Object)m.getModelVersion()));
        return POConverters.fromModelVersionPO(modelIdent, m, versionAliasRelPOs);
    }

    private static /* synthetic */ void lambda$listModelVersionsByNamespace$2(Multimap aliasRelPOsByModelVersion, ModelVersionAliasRelPO r) {
        aliasRelPOsByModelVersion.put((Object)r.getModelVersion(), (Object)r);
    }
}

