/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog;

import com.google.common.base.Preconditions;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.client.GravitinoMetalake;
import org.apache.gravitino.trino.connector.GravitinoConnector;
import org.apache.gravitino.trino.connector.GravitinoConnectorPluginManager;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;

public class CatalogConnectorContext {
    private final GravitinoCatalog catalog;
    private final GravitinoMetalake metalake;
    private final GravitinoConnector connector;
    private final Connector internalConnector;
    private final CatalogConnectorAdapter adapter;

    public CatalogConnectorContext(GravitinoCatalog catalog, GravitinoMetalake metalake, Connector internalConnector, CatalogConnectorAdapter adapter) {
        this.catalog = catalog;
        this.metalake = metalake;
        this.internalConnector = internalConnector;
        this.adapter = adapter;
        this.connector = new GravitinoConnector(catalog.geNameIdentifier(), this);
    }

    public GravitinoMetalake getMetalake() {
        return this.metalake;
    }

    public GravitinoCatalog getCatalog() {
        return this.catalog;
    }

    public GravitinoConnector getConnector() {
        return this.connector;
    }

    public Connector getInternalConnector() {
        return this.internalConnector;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.adapter.getTableProperties();
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.adapter.getSchemaProperties();
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.adapter.getColumnProperties();
    }

    public void close() {
        this.internalConnector.shutdown();
    }

    public CatalogConnectorMetadataAdapter getMetadataAdapter() {
        return this.adapter.getMetadataAdapter();
    }

    public static class Builder {
        private final CatalogConnectorAdapter connectorAdapter;
        private GravitinoCatalog catalog;
        private GravitinoMetalake metalake;
        private ConnectorContext context;

        public Builder(CatalogConnectorAdapter connectorAdapter) {
            this.connectorAdapter = connectorAdapter;
        }

        private Builder(CatalogConnectorAdapter connectorAdapter, GravitinoCatalog catalog) {
            this.connectorAdapter = connectorAdapter;
            this.catalog = catalog;
        }

        public Builder clone(GravitinoCatalog catalog) {
            return new Builder(this.connectorAdapter, catalog);
        }

        public Builder withMetalake(GravitinoMetalake metalake) {
            this.metalake = metalake;
            return this;
        }

        public Builder withContext(ConnectorContext context) {
            this.context = context;
            return this;
        }

        public CatalogConnectorContext build() throws Exception {
            Preconditions.checkArgument((this.metalake != null ? 1 : 0) != 0, (Object)"metalake is not null");
            Preconditions.checkArgument((this.catalog != null ? 1 : 0) != 0, (Object)"catalog is not null");
            Preconditions.checkArgument((this.context != null ? 1 : 0) != 0, (Object)"context is not null");
            Map<String, String> connectorConfig = this.connectorAdapter.buildInternalConnectorConfig(this.catalog);
            String internalConnectorName = this.connectorAdapter.internalConnectorName();
            Connector connector = GravitinoConnectorPluginManager.instance(this.context.getClass().getClassLoader()).createConnector(internalConnectorName, connectorConfig, this.context);
            return new CatalogConnectorContext(this.catalog, this.metalake, connector, this.connectorAdapter);
        }
    }
}

