/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.store.rdbms.connectionpool.DatastorePoolException;
import org.datanucleus.store.rdbms.datasource.dbcp.DriverManagerConnectionFactory;
import org.datanucleus.store.rdbms.datasource.dbcp.PoolableConnectionFactory;
import org.datanucleus.store.rdbms.datasource.dbcp.PoolingDataSource;
import org.datanucleus.store.rdbms.datasource.dbcp.pool.ObjectPool;
import org.datanucleus.store.rdbms.datasource.dbcp.pool.impl.GenericObjectPool;
import org.datanucleus.store.rdbms.datasource.dbcp.pool.impl.StackKeyedObjectPoolFactory;

public class DBCPBuiltinConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        int value;
        int value2;
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.loadDriver(dbDriver, clr);
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxIdle") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.maxIdle")) > 0) {
            connectionPool.setMaxIdle(value2);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.minIdle") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.minIdle")) > 0) {
            connectionPool.setMinIdle(value2);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxActive") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.maxActive")) > 0) {
            connectionPool.setMaxActive(value2);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxWait") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.maxWait")) > 0) {
            connectionPool.setMaxWait(value2);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis")) > 0) {
            connectionPool.setTimeBetweenEvictionRunsMillis(value2);
            int maxIdle = connectionPool.getMaxIdle();
            int numTestsPerEvictionRun = (int)Math.ceil((double)maxIdle / 4.0);
            connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis")) > 0) {
            connectionPool.setMinEvictableIdleTimeMillis(value2);
        }
        Properties dbProps = DBCPBuiltinConnectionPoolFactory.getPropertiesForDriver(storeMgr);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, dbProps);
        StackKeyedObjectPoolFactory kpf = null;
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxStatements") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxStatements")) > 0) {
            kpf = new StackKeyedObjectPoolFactory(value, value);
        }
        try {
            String testSQL = null;
            if (storeMgr.hasProperty("datanucleus.connectionPool.testSQL")) {
                testSQL = storeMgr.getStringProperty("datanucleus.connectionPool.testSQL");
            }
            new PoolableConnectionFactory(connectionFactory, connectionPool, kpf, testSQL, false, false);
            if (testSQL != null) {
                connectionPool.setTestOnBorrow(true);
            }
        }
        catch (Exception e) {
            throw new DatastorePoolException("DBCP", dbDriver, dbURL, e);
        }
        PoolingDataSource ds = new PoolingDataSource(connectionPool);
        return new DBCPConnectionPool(ds, connectionPool);
    }

    public class DBCPConnectionPool
    implements ConnectionPool {
        final PoolingDataSource dataSource;
        final ObjectPool pool;

        public DBCPConnectionPool(PoolingDataSource ds, ObjectPool pool) {
            this.dataSource = ds;
            this.pool = pool;
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

