/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.grails.encoder.impl;

import org.grails.encoder.CodecFactory;
import org.grails.encoder.CodecIdentifier;
import org.grails.encoder.Decoder;
import org.grails.encoder.Encoder;
import org.springframework.web.util.HtmlUtils;

public class XMLCodecFactory implements CodecFactory {
    protected Encoder encoder = new BasicXMLEncoder();
    protected Decoder decoder = new Decoder() {
        public CodecIdentifier getCodecIdentifier() {
            return BasicXMLEncoder.XML_CODEC_IDENTIFIER;
        }

        public Object decode(Object o) {
            if (o == null) {
                return null;
            }
            return HtmlUtils.htmlUnescape(String.valueOf(o));
        }
    };

    /* (non-Javadoc)
     * @see CodecFactory#getEncoder()
     */
    public Encoder getEncoder() {
        return encoder;
    }

    /* (non-Javadoc)
     * @see CodecFactory#getDecoder()
     */
    public Decoder getDecoder() {
        return decoder;
    }
}
