/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.fury.integration_tests;

import org.apache.fury.Fury;
import org.apache.fury.benchmark.data.MediaContent;
import org.apache.fury.benchmark.data.Sample;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FuryTest {

  @Test
  public void testMediaContent() {
    Sample object = new Sample().populate(false);
    Fury fury = Fury.builder().requireClassRegistration(false).build();
    byte[] data = fury.serialize(object);
    Sample sample = (Sample) fury.deserialize(data);
    Assert.assertEquals(sample, object);
  }

  @Test
  public void testSample() {
    MediaContent object = new MediaContent().populate(false);
    Fury fury = Fury.builder().requireClassRegistration(false).build();
    byte[] data = fury.serialize(object);
    MediaContent mediaContent = (MediaContent) fury.deserialize(data);
    Assert.assertEquals(mediaContent, object);
  }
}
