// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by MockGen. DO NOT EDIT.
// Source: /Users/chenzhou/horoc/incubator-eventmesh/eventmesh-server-go/plugin/connector/rocketmq/producer/rocketmq_producer.go

// Package mock is a generated GoMock package.
package mock

import (
	context "context"
	reflect "reflect"
	time "time"

	primitive "github.com/apache/rocketmq-client-go/v2/primitive"
	gomock "github.com/golang/mock/gomock"
)

// MockRocketMQProducer is a mock of RocketMQProducer interface.
type MockRocketMQProducer struct {
	ctrl     *gomock.Controller
	recorder *MockRocketMQProducerMockRecorder
}

// MockRocketMQProducerMockRecorder is the mock recorder for MockRocketMQProducer.
type MockRocketMQProducerMockRecorder struct {
	mock *MockRocketMQProducer
}

// NewMockRocketMQProducer creates a new mock instance.
func NewMockRocketMQProducer(ctrl *gomock.Controller) *MockRocketMQProducer {
	mock := &MockRocketMQProducer{ctrl: ctrl}
	mock.recorder = &MockRocketMQProducerMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockRocketMQProducer) EXPECT() *MockRocketMQProducerMockRecorder {
	return m.recorder
}

// Request mocks base method.
func (m *MockRocketMQProducer) Request(ctx context.Context, ttl time.Duration, msg *primitive.Message) (*primitive.Message, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Request", ctx, ttl, msg)
	ret0, _ := ret[0].(*primitive.Message)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// Request indicates an expected call of Request.
func (mr *MockRocketMQProducerMockRecorder) Request(ctx, ttl, msg interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Request", reflect.TypeOf((*MockRocketMQProducer)(nil).Request), ctx, ttl, msg)
}

// RequestAsync mocks base method.
func (m *MockRocketMQProducer) RequestAsync(ctx context.Context, ttl time.Duration, callback func(context.Context, *primitive.Message, error), msg *primitive.Message) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RequestAsync", ctx, ttl, callback, msg)
	ret0, _ := ret[0].(error)
	return ret0
}

// RequestAsync indicates an expected call of RequestAsync.
func (mr *MockRocketMQProducerMockRecorder) RequestAsync(ctx, ttl, callback, msg interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RequestAsync", reflect.TypeOf((*MockRocketMQProducer)(nil).RequestAsync), ctx, ttl, callback, msg)
}

// SendAsync mocks base method.
func (m *MockRocketMQProducer) SendAsync(ctx context.Context, mq func(context.Context, *primitive.SendResult, error), msg ...*primitive.Message) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx, mq}
	for _, a := range msg {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SendAsync", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// SendAsync indicates an expected call of SendAsync.
func (mr *MockRocketMQProducerMockRecorder) SendAsync(ctx, mq interface{}, msg ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx, mq}, msg...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendAsync", reflect.TypeOf((*MockRocketMQProducer)(nil).SendAsync), varargs...)
}

// SendOneWay mocks base method.
func (m *MockRocketMQProducer) SendOneWay(ctx context.Context, mq ...*primitive.Message) error {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx}
	for _, a := range mq {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SendOneWay", varargs...)
	ret0, _ := ret[0].(error)
	return ret0
}

// SendOneWay indicates an expected call of SendOneWay.
func (mr *MockRocketMQProducerMockRecorder) SendOneWay(ctx interface{}, mq ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx}, mq...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendOneWay", reflect.TypeOf((*MockRocketMQProducer)(nil).SendOneWay), varargs...)
}

// SendSync mocks base method.
func (m *MockRocketMQProducer) SendSync(ctx context.Context, mq ...*primitive.Message) (*primitive.SendResult, error) {
	m.ctrl.T.Helper()
	varargs := []interface{}{ctx}
	for _, a := range mq {
		varargs = append(varargs, a)
	}
	ret := m.ctrl.Call(m, "SendSync", varargs...)
	ret0, _ := ret[0].(*primitive.SendResult)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// SendSync indicates an expected call of SendSync.
func (mr *MockRocketMQProducerMockRecorder) SendSync(ctx interface{}, mq ...interface{}) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	varargs := append([]interface{}{ctx}, mq...)
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "SendSync", reflect.TypeOf((*MockRocketMQProducer)(nil).SendSync), varargs...)
}

// Shutdown mocks base method.
func (m *MockRocketMQProducer) Shutdown() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Shutdown")
	ret0, _ := ret[0].(error)
	return ret0
}

// Shutdown indicates an expected call of Shutdown.
func (mr *MockRocketMQProducerMockRecorder) Shutdown() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Shutdown", reflect.TypeOf((*MockRocketMQProducer)(nil).Shutdown))
}

// Start mocks base method.
func (m *MockRocketMQProducer) Start() error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "Start")
	ret0, _ := ret[0].(error)
	return ret0
}

// Start indicates an expected call of Start.
func (mr *MockRocketMQProducerMockRecorder) Start() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "Start", reflect.TypeOf((*MockRocketMQProducer)(nil).Start))
}
