/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: eventmesh-client.proto

package org.apache.eventmesh.common.protocol.grpc.protos;

import java.util.Objects;

import com.google.protobuf.ByteString;



/**
 * Protobuf type {@code eventmesh.common.protocol.grpc.Heartbeat}
 */
@SuppressWarnings({"all"})
public final class Heartbeat extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:eventmesh.common.protocol.grpc.Heartbeat)
        HeartbeatOrBuilder {
    private static final long serialVersionUID = -617903330545075556L;

    // Use Heartbeat.newBuilder() to construct.
    private Heartbeat(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Heartbeat() {
        clientType_ = 0;
        producerGroup_ = "";
        consumerGroup_ = "";
        heartbeatItems_ = java.util.Collections.emptyList();
    }

    @Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
        return this.unknownFields;
    }

    private Heartbeat(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0:
                        done = true;
                        break;
                    default: {
                        if (!parseUnknownFieldProto3(
                                input, unknownFields, extensionRegistry, tag)) {
                            done = true;
                        }
                        break;
                    }
                    case 10: {
                        RequestHeader.Builder subBuilder = null;
                        if (header_ != null) {
                            subBuilder = header_.toBuilder();
                        }
                        header_ = input.readMessage(RequestHeader.parser(), extensionRegistry);
                        if (subBuilder != null) {
                            subBuilder.mergeFrom(header_);
                            header_ = subBuilder.buildPartial();
                        }

                        break;
                    }
                    case 16: {
                        clientType_ = input.readEnum();
                        break;
                    }
                    case 26: {
                        producerGroup_ = input.readStringRequireUtf8();
                        break;
                    }
                    case 34: {
                        consumerGroup_ = input.readStringRequireUtf8();
                        break;
                    }
                    case 42: {
                        if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                            heartbeatItems_ = new java.util.ArrayList<HeartbeatItem>();
                            mutable_bitField0_ |= 0x00000010;
                        }
                        heartbeatItems_.add(
                                input.readMessage(HeartbeatItem.parser(), extensionRegistry));
                        break;
                    }
                }
            }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(
                    e).setUnfinishedMessage(this);
        } finally {
            if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                heartbeatItems_ = java.util.Collections.unmodifiableList(heartbeatItems_);
            }
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
        }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_descriptor;
    }

    protected FieldAccessorTable internalGetFieldAccessorTable() {
        return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                        Heartbeat.class, Builder.class);
    }

    /**
     * Protobuf enum {@code eventmesh.common.protocol.grpc.Heartbeat.ClientType}
     */
    public enum ClientType
            implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>PUB = 0;</code>
         */
        PUB(0),
        /**
         * <code>SUB = 1;</code>
         */
        SUB(1),
        UNRECOGNIZED(-1),
        ;

        /**
         * <code>PUB = 0;</code>
         */
        public static final int PUB_VALUE = 0;
        /**
         * <code>SUB = 1;</code>
         */
        public static final int SUB_VALUE = 1;


        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException(
                        "Can't get the number of an unknown enum value.");
            }
            return value;
        }

        /**
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @Deprecated
        public static ClientType valueOf(int value) {
            return forNumber(value);
        }

        public static ClientType forNumber(int value) {
            switch (value) {
                case 0:
                    return PUB;
                case 1:
                    return SUB;
                default:
                    return null;
            }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ClientType>
        internalGetValueMap() {
            return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<
                ClientType> internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<ClientType>() {
                    public ClientType findValueByNumber(int number) {
                        return ClientType.forNumber(number);
                    }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
            return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
            return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
            return Heartbeat.getDescriptor().getEnumTypes().get(0);
        }

        private static final ClientType[] VALUES = values();

        public static ClientType valueOf(
                com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
                throw new IllegalArgumentException(
                        "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private final int value;

        private ClientType(int value) {
            this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:eventmesh.common.protocol.grpc.Heartbeat.ClientType)
    }

    public interface HeartbeatItemOrBuilder extends
            // @@protoc_insertion_point(interface_extends:eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem)
            com.google.protobuf.MessageOrBuilder {

        /**
         * <code>string topic = 1;</code>
         */
        String getTopic();

        /**
         * <code>string topic = 1;</code>
         */
        com.google.protobuf.ByteString
        getTopicBytes();

        /**
         * <code>string url = 2;</code>
         */
        String getUrl();

        /**
         * <code>string url = 2;</code>
         */
        com.google.protobuf.ByteString
        getUrlBytes();
    }

    /**
     * Protobuf type {@code eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem}
     */
    public static final class HeartbeatItem extends
            com.google.protobuf.GeneratedMessageV3 implements
            // @@protoc_insertion_point(message_implements:eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem)
            HeartbeatItemOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use HeartbeatItem.newBuilder() to construct.
        private HeartbeatItem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private HeartbeatItem() {
            topic_ = "";
            url_ = "";
        }

        @Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
            return this.unknownFields;
        }

        private HeartbeatItem(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                    com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0:
                            done = true;
                            break;
                        default: {
                            if (!parseUnknownFieldProto3(
                                    input, unknownFields, extensionRegistry, tag)) {
                                done = true;
                            }
                            break;
                        }
                        case 10: {
                            topic_ = input.readStringRequireUtf8();
                            break;
                        }
                        case 18: {
                            url_ = input.readStringRequireUtf8();
                            break;
                        }
                    }
                }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(
                        e).setUnfinishedMessage(this);
            } finally {
                this.unknownFields = unknownFields.build();
                makeExtensionsImmutable();
            }
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_HeartbeatItem_descriptor;
        }

        protected FieldAccessorTable
        internalGetFieldAccessorTable() {
            return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_HeartbeatItem_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                            HeartbeatItem.class, Builder.class);
        }

        public static final int TOPIC_FIELD_NUMBER = 1;
        private volatile String topic_;

        /**
         * <code>string topic = 1;</code>
         */
        public String getTopic() {
            return topic_;
        }

        /**
         * <code>string topic = 1;</code>
         */
        public com.google.protobuf.ByteString getTopicBytes() {
            return ByteString.copyFromUtf8(topic_);
        }

        public static final int URL_FIELD_NUMBER = 2;
        private volatile String url_;

        /**
         * <code>string url = 2;</code>
         */
        public String getUrl() {
            return url_;
        }

        /**
         * <code>string url = 2;</code>
         */
        public com.google.protobuf.ByteString getUrlBytes() {
            return ByteString.copyFromUtf8(url_);
        }

        private byte memoizedIsInitialized = -1;

        public final boolean isInitialized() {
            if (memoizedIsInitialized == 1) return true;
            if (memoizedIsInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(com.google.protobuf.CodedOutputStream output)
                throws java.io.IOException {
            if (!getTopicBytes().isEmpty()) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, topic_);
            }
            if (!getUrlBytes().isEmpty()) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 2, url_);
            }
            unknownFields.writeTo(output);
        }

        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (!getTopicBytes().isEmpty()) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, topic_);
            }
            if (!getUrlBytes().isEmpty()) {
                size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, url_);
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @Override
        public boolean equals(final Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof HeartbeatItem)) {
                return super.equals(obj);
            }
            HeartbeatItem other = (HeartbeatItem) obj;

            return getTopic().equals(other.getTopic())
                    && getUrl().equals(other.getUrl())
                    && unknownFields.equals(other.unknownFields);
        }

        @Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + TOPIC_FIELD_NUMBER;
            hash = (53 * hash) + getTopic().hashCode();
            hash = (37 * hash) + URL_FIELD_NUMBER;
            hash = (53 * hash) + getUrl().hashCode();
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static HeartbeatItem parseFrom(
                java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static HeartbeatItem parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static HeartbeatItem parseFrom(
                com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static HeartbeatItem parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static HeartbeatItem parseFrom(byte[] data)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static HeartbeatItem parseFrom(
                byte[] data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static HeartbeatItem parseFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }

        public static HeartbeatItem parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static HeartbeatItem parseDelimitedFrom(java.io.InputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input);
        }

        public static HeartbeatItem parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static HeartbeatItem parseFrom(
                com.google.protobuf.CodedInputStream input)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input);
        }

        public static HeartbeatItem parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                    .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public Builder newBuilderForType() {
            return newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(HeartbeatItem prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                    ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(
                BuilderParent parent) {
            return new Builder(parent);
        }

        /**
         * Protobuf type {@code eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem}
         */
        public static final class Builder extends
                com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
                // @@protoc_insertion_point(builder_implements:eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem)
                HeartbeatItemOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_HeartbeatItem_descriptor;
            }

            protected FieldAccessorTable
            internalGetFieldAccessorTable() {
                return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_HeartbeatItem_fieldAccessorTable
                        .ensureFieldAccessorsInitialized(
                                HeartbeatItem.class, Builder.class);
            }

            // Construct using org.apache.eventmesh.common.protocol.grpc.protos.Heartbeat.HeartbeatItem.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                    BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (com.google.protobuf.GeneratedMessageV3
                        .alwaysUseFieldBuilders) {
                }
            }

            public Builder clear() {
                super.clear();
                topic_ = "";
                url_ = "";

                return this;
            }

            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_HeartbeatItem_descriptor;
            }

            public HeartbeatItem getDefaultInstanceForType() {
                return HeartbeatItem.getDefaultInstance();
            }

            public HeartbeatItem build() {
                HeartbeatItem result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            public HeartbeatItem buildPartial() {
                HeartbeatItem result = new HeartbeatItem(this);
                result.topic_ = topic_;
                result.url_ = url_;
                onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder) super.clone();
            }

            public Builder setField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    Object value) {
                return (Builder) super.setField(field, value);
            }

            public Builder clearField(
                    com.google.protobuf.Descriptors.FieldDescriptor field) {
                return (Builder) super.clearField(field);
            }

            public Builder clearOneof(
                    com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return (Builder) super.clearOneof(oneof);
            }

            public Builder setRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    int index, Object value) {
                return (Builder) super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(
                    com.google.protobuf.Descriptors.FieldDescriptor field,
                    Object value) {
                return (Builder) super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof HeartbeatItem) {
                    return mergeFrom((HeartbeatItem) other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(HeartbeatItem other) {
                if (other == HeartbeatItem.getDefaultInstance()) return this;
                if (!other.getTopic().isEmpty()) {
                    topic_ = other.topic_;
                    onChanged();
                }
                if (!other.getUrl().isEmpty()) {
                    url_ = other.url_;
                    onChanged();
                }
                this.mergeUnknownFields(other.unknownFields);
                onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws java.io.IOException {
                HeartbeatItem parsedMessage = null;
                try {
                    parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    parsedMessage = (HeartbeatItem) e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                } finally {
                    if (parsedMessage != null) {
                        mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private String topic_ = "";

            /**
             * <code>string topic = 1;</code>
             */
            public String getTopic() {
                return topic_;
            }

            /**
             * <code>string topic = 1;</code>
             */
            public com.google.protobuf.ByteString getTopicBytes() {
                return ByteString.copyFromUtf8(topic_);
            }

            /**
             * <code>string topic = 1;</code>
             */
            public Builder setTopic(
                    String value) {
                Objects.requireNonNull(value, "topic can not be null");

                topic_ = value;
                onChanged();
                return this;
            }

            /**
             * <code>string topic = 1;</code>
             */
            public Builder clearTopic() {

                topic_ = getDefaultInstance().getTopic();
                onChanged();
                return this;
            }

            /**
             * <code>string topic = 1;</code>
             */
            public Builder setTopicBytes(
                    com.google.protobuf.ByteString value) {
                Objects.requireNonNull(value, "TopicBytes can not be null");

                checkByteStringIsUtf8(value);

                topic_ = value.toStringUtf8();
                onChanged();
                return this;
            }

            private String url_ = "";

            /**
             * <code>string url = 2;</code>
             */
            public String getUrl() {
                return url_;
            }

            /**
             * <code>string url = 2;</code>
             */
            public com.google.protobuf.ByteString getUrlBytes() {
                return ByteString.copyFromUtf8(url_);
            }

            /**
             * <code>string url = 2;</code>
             */
            public Builder setUrl(
                    String value) {
                Objects.requireNonNull(value, "url can not be null");

                url_ = value;
                onChanged();
                return this;
            }

            /**
             * <code>string url = 2;</code>
             */
            public Builder clearUrl() {

                url_ = getDefaultInstance().getUrl();
                onChanged();
                return this;
            }

            /**
             * <code>string url = 2;</code>
             */
            public Builder setUrlBytes(
                    com.google.protobuf.ByteString value) {
                Objects.requireNonNull(value, "UrlBytes can not be null");
                checkByteStringIsUtf8(value);

                url_ = value.toStringUtf8();
                onChanged();
                return this;
            }

            public final Builder setUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFieldsProto3(unknownFields);
            }

            public final Builder mergeUnknownFields(
                    final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem)
        }

        // @@protoc_insertion_point(class_scope:eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem)
        private static final HeartbeatItem DEFAULT_INSTANCE;

        static {
            DEFAULT_INSTANCE = new HeartbeatItem();
        }

        public static HeartbeatItem getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<HeartbeatItem>
                PARSER = new com.google.protobuf.AbstractParser<HeartbeatItem>() {
            public HeartbeatItem parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                return new HeartbeatItem(input, extensionRegistry);
            }
        };

        public static com.google.protobuf.Parser<HeartbeatItem> parser() {
            return PARSER;
        }

        @Override
        public com.google.protobuf.Parser<HeartbeatItem> getParserForType() {
            return PARSER;
        }

        public HeartbeatItem getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    private int bitField0_;
    public static final int HEADER_FIELD_NUMBER = 1;
    private RequestHeader header_;

    /**
     * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
     */
    public boolean hasHeader() {
        return header_ != null;
    }

    /**
     * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
     */
    public RequestHeader getHeader() {
        return header_ == null ? RequestHeader.getDefaultInstance() : header_;
    }

    /**
     * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
     */
    public RequestHeaderOrBuilder getHeaderOrBuilder() {
        return getHeader();
    }

    public static final int CLIENTTYPE_FIELD_NUMBER = 2;
    private int clientType_;

    /**
     * <code>.eventmesh.common.protocol.grpc.Heartbeat.ClientType clientType = 2;</code>
     */
    public int getClientTypeValue() {
        return clientType_;
    }

    /**
     * <code>.eventmesh.common.protocol.grpc.Heartbeat.ClientType clientType = 2;</code>
     */
    public ClientType getClientType() {
        ClientType result = ClientType.valueOf(clientType_);
        return result == null ? ClientType.UNRECOGNIZED : result;
    }

    public static final int PRODUCERGROUP_FIELD_NUMBER = 3;
    private volatile String producerGroup_;

    /**
     * <code>string producerGroup = 3;</code>
     */
    public String getProducerGroup() {
        return producerGroup_;
    }

    /**
     * <code>string producerGroup = 3;</code>
     */
    public com.google.protobuf.ByteString
    getProducerGroupBytes() {
        return ByteString.copyFromUtf8(producerGroup_);
    }

    public static final int CONSUMERGROUP_FIELD_NUMBER = 4;
    private volatile String consumerGroup_;

    /**
     * <code>string consumerGroup = 4;</code>
     */
    public String getConsumerGroup() {
        return consumerGroup_;
    }

    /**
     * <code>string consumerGroup = 4;</code>
     */
    public com.google.protobuf.ByteString
    getConsumerGroupBytes() {
        return ByteString.copyFromUtf8(consumerGroup_);
    }

    public static final int HEARTBEATITEMS_FIELD_NUMBER = 5;
    private java.util.List<HeartbeatItem> heartbeatItems_;

    /**
     * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
     */
    public java.util.List<HeartbeatItem> getHeartbeatItemsList() {
        return heartbeatItems_;
    }

    /**
     * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
     */
    public java.util.List<? extends HeartbeatItemOrBuilder>
    getHeartbeatItemsOrBuilderList() {
        return heartbeatItems_;
    }

    /**
     * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
     */
    public int getHeartbeatItemsCount() {
        return heartbeatItems_.size();
    }

    /**
     * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
     */
    public HeartbeatItem getHeartbeatItems(int index) {
        return heartbeatItems_.get(index);
    }

    /**
     * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
     */
    public HeartbeatItemOrBuilder getHeartbeatItemsOrBuilder(
            int index) {
        return heartbeatItems_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
        if (header_ != null) {
            output.writeMessage(1, getHeader());
        }
        if (clientType_ != ClientType.PUB.getNumber()) {
            output.writeEnum(2, clientType_);
        }
        if (!getProducerGroupBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, producerGroup_);
        }
        if (!getConsumerGroupBytes().isEmpty()) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 4, consumerGroup_);
        }
        for (HeartbeatItem heartbeatItem : heartbeatItems_) {
            output.writeMessage(5, heartbeatItem);
        }
        unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (header_ != null) {
            size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(1, getHeader());
        }
        if (clientType_ != ClientType.PUB.getNumber()) {
            size += com.google.protobuf.CodedOutputStream
                    .computeEnumSize(2, clientType_);
        }
        if (!getProducerGroupBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, producerGroup_);
        }
        if (!getConsumerGroupBytes().isEmpty()) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, consumerGroup_);
        }
        for (HeartbeatItem heartbeatItem : heartbeatItems_) {
            size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(5, heartbeatItem);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Heartbeat)) {
            return super.equals(obj);
        }
        Heartbeat other = (Heartbeat) obj;

        return hasHeader() == other.hasHeader()
                && hasHeader() ? getHeader().equals(other.getHeader()) : true
                && clientType_ == other.clientType_
                && getProducerGroup().equals(other.getProducerGroup())
                && getConsumerGroup().equals(other.getConsumerGroup())
                && getHeartbeatItemsList().equals(other.getHeartbeatItemsList())
                && unknownFields.equals(other.unknownFields);
    }

    @Override
    public int hashCode() {
        if (memoizedHashCode != 0) {
            return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasHeader()) {
            hash = (37 * hash) + HEADER_FIELD_NUMBER;
            hash = (53 * hash) + getHeader().hashCode();
        }
        hash = (37 * hash) + CLIENTTYPE_FIELD_NUMBER;
        hash = (53 * hash) + clientType_;
        hash = (37 * hash) + PRODUCERGROUP_FIELD_NUMBER;
        hash = (53 * hash) + getProducerGroup().hashCode();
        hash = (37 * hash) + CONSUMERGROUP_FIELD_NUMBER;
        hash = (53 * hash) + getConsumerGroup().hashCode();
        if (getHeartbeatItemsCount() > 0) {
            hash = (37 * hash) + HEARTBEATITEMS_FIELD_NUMBER;
            hash = (53 * hash) + getHeartbeatItemsList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
    }

    public static Heartbeat parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Heartbeat parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Heartbeat parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Heartbeat parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Heartbeat parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
    }

    public static Heartbeat parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
    }

    public static Heartbeat parseFrom(java.io.InputStream input)
            throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
    }

    public static Heartbeat parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static Heartbeat parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
    }

    public static Heartbeat parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }

    public static Heartbeat parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
    }

    public static Heartbeat parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() {
        return newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Heartbeat prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
    }

    @Override
    protected Builder newBuilderForType(
            BuilderParent parent) {
        return new Builder(parent);
    }

    /**
     * Protobuf type {@code eventmesh.common.protocol.grpc.Heartbeat}
     */
    public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:eventmesh.common.protocol.grpc.Heartbeat)
            HeartbeatOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_descriptor;
        }

        protected FieldAccessorTable
        internalGetFieldAccessorTable() {
            return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                            Heartbeat.class, Builder.class);
        }

        // Construct using org.apache.eventmesh.common.protocol.grpc.protos.Heartbeat.newBuilder()
        private Builder() {
            maybeForceBuilderInitialization();
        }

        private Builder(
                BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
                getHeartbeatItemsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            if (headerBuilder_ == null) {
                header_ = null;
            } else {
                header_ = null;
                headerBuilder_ = null;
            }
            clientType_ = 0;

            producerGroup_ = "";

            consumerGroup_ = "";

            if (heartbeatItemsBuilder_ == null) {
                heartbeatItems_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000010);
            } else {
                heartbeatItemsBuilder_.clear();
            }
            return this;
        }

        public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
            return EventmeshGrpc.internal_static_eventmesh_common_protocol_grpc_Heartbeat_descriptor;
        }

        public Heartbeat getDefaultInstanceForType() {
            return Heartbeat.getDefaultInstance();
        }

        public Heartbeat build() {
            Heartbeat result = buildPartial();
            if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
            }
            return result;
        }

        public Heartbeat buildPartial() {
            Heartbeat result = new Heartbeat(this);
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (headerBuilder_ == null) {
                result.header_ = header_;
            } else {
                result.header_ = headerBuilder_.build();
            }
            result.clientType_ = clientType_;
            result.producerGroup_ = producerGroup_;
            result.consumerGroup_ = consumerGroup_;
            if (heartbeatItemsBuilder_ == null) {
                if (((bitField0_ & 0x00000010) == 0x00000010)) {
                    heartbeatItems_ = java.util.Collections.unmodifiableList(heartbeatItems_);
                    bitField0_ = (bitField0_ & ~0x00000010);
                }
                result.heartbeatItems_ = heartbeatItems_;
            } else {
                result.heartbeatItems_ = heartbeatItemsBuilder_.build();
            }
            result.bitField0_ = to_bitField0_;
            onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder) super.clone();
        }

        public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                Object value) {
            return (Builder) super.setField(field, value);
        }

        public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
            return (Builder) super.clearField(field);
        }

        public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return (Builder) super.clearOneof(oneof);
        }

        public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, Object value) {
            return (Builder) super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                Object value) {
            return (Builder) super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof Heartbeat) {
                return mergeFrom((Heartbeat) other);
            } else {
                super.mergeFrom(other);
                return this;
            }
        }

        public Builder mergeFrom(Heartbeat other) {
            if (other == Heartbeat.getDefaultInstance()) return this;
            if (other.hasHeader()) {
                mergeHeader(other.getHeader());
            }
            if (other.clientType_ != 0) {
                setClientTypeValue(other.getClientTypeValue());
            }
            if (!other.getProducerGroup().isEmpty()) {
                producerGroup_ = other.producerGroup_;
                onChanged();
            }
            if (!other.getConsumerGroup().isEmpty()) {
                consumerGroup_ = other.consumerGroup_;
                onChanged();
            }
            if (heartbeatItemsBuilder_ == null) {
                if (!other.heartbeatItems_.isEmpty()) {
                    if (heartbeatItems_.isEmpty()) {
                        heartbeatItems_ = other.heartbeatItems_;
                        bitField0_ = (bitField0_ & ~0x00000010);
                    } else {
                        ensureHeartbeatItemsIsMutable();
                        heartbeatItems_.addAll(other.heartbeatItems_);
                    }
                    onChanged();
                }
            } else {
                if (!other.heartbeatItems_.isEmpty()) {
                    if (heartbeatItemsBuilder_.isEmpty()) {
                        heartbeatItemsBuilder_.dispose();
                        heartbeatItemsBuilder_ = null;
                        heartbeatItems_ = other.heartbeatItems_;
                        bitField0_ = (bitField0_ & ~0x00000010);
                        heartbeatItemsBuilder_ =
                                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                                        getHeartbeatItemsFieldBuilder() : null;
                    } else {
                        heartbeatItemsBuilder_.addAllMessages(other.heartbeatItems_);
                    }
                }
            }
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
            Heartbeat parsedMessage = null;
            try {
                parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                parsedMessage = (Heartbeat) e.getUnfinishedMessage();
                throw e.unwrapIOException();
            } finally {
                if (parsedMessage != null) {
                    mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        private int bitField0_;

        private RequestHeader header_ = null;
        private com.google.protobuf.SingleFieldBuilderV3<
                RequestHeader, RequestHeader.Builder, RequestHeaderOrBuilder> headerBuilder_;

        /**
         * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
         */
        public boolean hasHeader() {
            return headerBuilder_ != null || header_ != null;
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
         */
        public RequestHeader getHeader() {
            if (headerBuilder_ == null) {
                return header_ == null ? RequestHeader.getDefaultInstance() : header_;
            } else {
                return headerBuilder_.getMessage();
            }
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
         */
        public Builder setHeader(RequestHeader value) {
            if (headerBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                header_ = value;
                onChanged();
            } else {
                headerBuilder_.setMessage(value);
            }

            return this;
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
         */
        public Builder setHeader(
                RequestHeader.Builder builderForValue) {
            if (headerBuilder_ == null) {
                header_ = builderForValue.build();
                onChanged();
            } else {
                headerBuilder_.setMessage(builderForValue.build());
            }

            return this;
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
         */
        public Builder mergeHeader(RequestHeader value) {
            if (headerBuilder_ == null) {
                if (header_ != null) {
                    header_ =
                            RequestHeader.newBuilder(header_).mergeFrom(value).buildPartial();
                } else {
                    header_ = value;
                }
                onChanged();
            } else {
                headerBuilder_.mergeFrom(value);
            }

            return this;
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
         */
        public Builder clearHeader() {
            if (headerBuilder_ == null) {
                header_ = null;
                onChanged();
            } else {
                header_ = null;
                headerBuilder_ = null;
            }

            return this;
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
         */
        public RequestHeader.Builder getHeaderBuilder() {

            onChanged();
            return getHeaderFieldBuilder().getBuilder();
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
         */
        public RequestHeaderOrBuilder getHeaderOrBuilder() {
            if (headerBuilder_ != null) {
                return headerBuilder_.getMessageOrBuilder();
            } else {
                return header_ == null ?
                        RequestHeader.getDefaultInstance() : header_;
            }
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.RequestHeader header = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                RequestHeader, RequestHeader.Builder, RequestHeaderOrBuilder>
        getHeaderFieldBuilder() {
            if (headerBuilder_ == null) {
                headerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                        RequestHeader, RequestHeader.Builder, RequestHeaderOrBuilder>(
                        getHeader(),
                        getParentForChildren(),
                        isClean());
                header_ = null;
            }
            return headerBuilder_;
        }

        private int clientType_ = 0;

        /**
         * <code>.eventmesh.common.protocol.grpc.Heartbeat.ClientType clientType = 2;</code>
         */
        public int getClientTypeValue() {
            return clientType_;
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.Heartbeat.ClientType clientType = 2;</code>
         */
        public Builder setClientTypeValue(int value) {
            clientType_ = value;
            onChanged();
            return this;
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.Heartbeat.ClientType clientType = 2;</code>
         */
        public ClientType getClientType() {
            ClientType result = ClientType.valueOf(clientType_);
            return result == null ? ClientType.UNRECOGNIZED : result;
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.Heartbeat.ClientType clientType = 2;</code>
         */
        public Builder setClientType(ClientType value) {
            if (value == null) {
                throw new NullPointerException();
            }

            clientType_ = value.getNumber();
            onChanged();
            return this;
        }

        /**
         * <code>.eventmesh.common.protocol.grpc.Heartbeat.ClientType clientType = 2;</code>
         */
        public Builder clearClientType() {

            clientType_ = 0;
            onChanged();
            return this;
        }

        private String producerGroup_ = "";

        /**
         * <code>string producerGroup = 3;</code>
         */
        public String getProducerGroup() {
            return producerGroup_;
        }

        /**
         * <code>string producerGroup = 3;</code>
         */
        public com.google.protobuf.ByteString
        getProducerGroupBytes() {
            return ByteString.copyFromUtf8(producerGroup_);
        }

        /**
         * <code>string producerGroup = 3;</code>
         */
        public Builder setProducerGroup(
                String value) {
            Objects.requireNonNull(value, "ProducerGroup can not be null");

            producerGroup_ = value;
            onChanged();
            return this;
        }

        /**
         * <code>string producerGroup = 3;</code>
         */
        public Builder clearProducerGroup() {

            producerGroup_ = getDefaultInstance().getProducerGroup();
            onChanged();
            return this;
        }

        /**
         * <code>string producerGroup = 3;</code>
         */
        public Builder setProducerGroupBytes(
                com.google.protobuf.ByteString value) {
            Objects.requireNonNull(value, "ProducerGroupBytes can not be null");
            checkByteStringIsUtf8(value);

            producerGroup_ = value.toStringUtf8();
            onChanged();
            return this;
        }

        private String consumerGroup_ = "";

        /**
         * <code>string consumerGroup = 4;</code>
         */
        public String getConsumerGroup() {
            return consumerGroup_;
        }

        /**
         * <code>string consumerGroup = 4;</code>
         */
        public com.google.protobuf.ByteString
        getConsumerGroupBytes() {
            return ByteString.copyFromUtf8(consumerGroup_);
        }

        /**
         * <code>string consumerGroup = 4;</code>
         */
        public Builder setConsumerGroup(
                String value) {
            Objects.requireNonNull(value, "ConsumerGroup can not be null");

            consumerGroup_ = value;
            onChanged();
            return this;
        }

        /**
         * <code>string consumerGroup = 4;</code>
         */
        public Builder clearConsumerGroup() {

            consumerGroup_ = getDefaultInstance().getConsumerGroup();
            onChanged();
            return this;
        }

        /**
         * <code>string consumerGroup = 4;</code>
         */
        public Builder setConsumerGroupBytes(
                com.google.protobuf.ByteString value) {
            Objects.requireNonNull(value, "ConsumerGroupBytes can not be null");
            checkByteStringIsUtf8(value);

            consumerGroup_ = value.toStringUtf8();
            onChanged();
            return this;
        }

        private java.util.List<HeartbeatItem> heartbeatItems_ =
                java.util.Collections.emptyList();

        private void ensureHeartbeatItemsIsMutable() {
            if (!((bitField0_ & 0x00000010) == 0x00000010)) {
                heartbeatItems_ = new java.util.ArrayList<HeartbeatItem>(heartbeatItems_);
                bitField0_ |= 0x00000010;
            }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                HeartbeatItem, HeartbeatItem.Builder, HeartbeatItemOrBuilder> heartbeatItemsBuilder_;

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public java.util.List<HeartbeatItem> getHeartbeatItemsList() {
            if (heartbeatItemsBuilder_ == null) {
                return java.util.Collections.unmodifiableList(heartbeatItems_);
            } else {
                return heartbeatItemsBuilder_.getMessageList();
            }
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public int getHeartbeatItemsCount() {
            if (heartbeatItemsBuilder_ == null) {
                return heartbeatItems_.size();
            } else {
                return heartbeatItemsBuilder_.getCount();
            }
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public HeartbeatItem getHeartbeatItems(int index) {
            if (heartbeatItemsBuilder_ == null) {
                return heartbeatItems_.get(index);
            } else {
                return heartbeatItemsBuilder_.getMessage(index);
            }
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public Builder setHeartbeatItems(
                int index, HeartbeatItem value) {
            if (heartbeatItemsBuilder_ == null) {
                Objects.requireNonNull(value, "HeartbeatItem can not be null");
                ensureHeartbeatItemsIsMutable();
                heartbeatItems_.set(index, value);
                onChanged();
            } else {
                heartbeatItemsBuilder_.setMessage(index, value);
            }
            return this;
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public Builder setHeartbeatItems(
                int index, HeartbeatItem.Builder builderForValue) {
            if (heartbeatItemsBuilder_ == null) {
                ensureHeartbeatItemsIsMutable();
                heartbeatItems_.set(index, builderForValue.build());
                onChanged();
            } else {
                heartbeatItemsBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public Builder addHeartbeatItems(HeartbeatItem value) {
            if (heartbeatItemsBuilder_ == null) {
                Objects.requireNonNull(value, "HeartbeatItem can not be null");
                ensureHeartbeatItemsIsMutable();
                heartbeatItems_.add(value);
                onChanged();
            } else {
                heartbeatItemsBuilder_.addMessage(value);
            }
            return this;
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public Builder addHeartbeatItems(
                int index, HeartbeatItem value) {
            if (heartbeatItemsBuilder_ == null) {
                Objects.requireNonNull(value, "HeartbeatItem can not be null");
                ensureHeartbeatItemsIsMutable();
                heartbeatItems_.add(index, value);
                onChanged();
            } else {
                heartbeatItemsBuilder_.addMessage(index, value);
            }
            return this;
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public Builder addHeartbeatItems(
                HeartbeatItem.Builder builderForValue) {
            if (heartbeatItemsBuilder_ == null) {
                ensureHeartbeatItemsIsMutable();
                heartbeatItems_.add(builderForValue.build());
                onChanged();
            } else {
                heartbeatItemsBuilder_.addMessage(builderForValue.build());
            }
            return this;
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public Builder addHeartbeatItems(
                int index, HeartbeatItem.Builder builderForValue) {
            if (heartbeatItemsBuilder_ == null) {
                ensureHeartbeatItemsIsMutable();
                heartbeatItems_.add(index, builderForValue.build());
                onChanged();
            } else {
                heartbeatItemsBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public Builder addAllHeartbeatItems(
                Iterable<? extends HeartbeatItem> values) {
            if (heartbeatItemsBuilder_ == null) {
                ensureHeartbeatItemsIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                        values, heartbeatItems_);
                onChanged();
            } else {
                heartbeatItemsBuilder_.addAllMessages(values);
            }
            return this;
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public Builder clearHeartbeatItems() {
            if (heartbeatItemsBuilder_ == null) {
                heartbeatItems_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000010);
                onChanged();
            } else {
                heartbeatItemsBuilder_.clear();
            }
            return this;
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public Builder removeHeartbeatItems(int index) {
            if (heartbeatItemsBuilder_ == null) {
                ensureHeartbeatItemsIsMutable();
                heartbeatItems_.remove(index);
                onChanged();
            } else {
                heartbeatItemsBuilder_.remove(index);
            }
            return this;
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public HeartbeatItem.Builder getHeartbeatItemsBuilder(
                int index) {
            return getHeartbeatItemsFieldBuilder().getBuilder(index);
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public HeartbeatItemOrBuilder getHeartbeatItemsOrBuilder(
                int index) {
            if (heartbeatItemsBuilder_ == null) {
                return heartbeatItems_.get(index);
            } else {
                return heartbeatItemsBuilder_.getMessageOrBuilder(index);
            }
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public java.util.List<? extends HeartbeatItemOrBuilder>
        getHeartbeatItemsOrBuilderList() {
            if (heartbeatItemsBuilder_ != null) {
                return heartbeatItemsBuilder_.getMessageOrBuilderList();
            } else {
                return java.util.Collections.unmodifiableList(heartbeatItems_);
            }
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public HeartbeatItem.Builder addHeartbeatItemsBuilder() {
            return getHeartbeatItemsFieldBuilder().addBuilder(
                    HeartbeatItem.getDefaultInstance());
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public HeartbeatItem.Builder addHeartbeatItemsBuilder(
                int index) {
            return getHeartbeatItemsFieldBuilder().addBuilder(
                    index, HeartbeatItem.getDefaultInstance());
        }

        /**
         * <code>repeated .eventmesh.common.protocol.grpc.Heartbeat.HeartbeatItem heartbeatItems = 5;</code>
         */
        public java.util.List<HeartbeatItem.Builder>
        getHeartbeatItemsBuilderList() {
            return getHeartbeatItemsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                HeartbeatItem, HeartbeatItem.Builder, HeartbeatItemOrBuilder>
        getHeartbeatItemsFieldBuilder() {
            if (heartbeatItemsBuilder_ == null) {
                heartbeatItemsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                        HeartbeatItem, HeartbeatItem.Builder, HeartbeatItemOrBuilder>(
                        heartbeatItems_,
                        ((bitField0_ & 0x00000010) == 0x00000010),
                        getParentForChildren(),
                        isClean());
                heartbeatItems_ = null;
            }
            return heartbeatItemsBuilder_;
        }

        public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFieldsProto3(unknownFields);
        }

        public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:eventmesh.common.protocol.grpc.Heartbeat)
    }

    // @@protoc_insertion_point(class_scope:eventmesh.common.protocol.grpc.Heartbeat)
    private static final Heartbeat DEFAULT_INSTANCE;

    static {
        DEFAULT_INSTANCE = new Heartbeat();
    }

    public static Heartbeat getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Heartbeat>
            PARSER = new com.google.protobuf.AbstractParser<Heartbeat>() {
        public Heartbeat parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
            return new Heartbeat(input, extensionRegistry);
        }
    };

    public static com.google.protobuf.Parser<Heartbeat> parser() {
        return PARSER;
    }

    @Override
    public com.google.protobuf.Parser<Heartbeat> getParserForType() {
        return PARSER;
    }

    public Heartbeat getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

}

