/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.eventmesh.common.enums.HttpMethod;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);

    public static Map<String, String> formData2Dic(String formData) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (formData == null || formData.trim().length() == 0) {
            return result;
        }
        String[] items = formData.split("&");
        Arrays.stream(items).forEach(item -> {
            String[] keyAndVal = item.split("=");
            if (keyAndVal.length == 2) {
                try {
                    String key = URLDecoder.decode(keyAndVal[0], StandardCharsets.UTF_8.name());
                    String val = URLDecoder.decode(keyAndVal[1], StandardCharsets.UTF_8.name());
                    result.put(key, val);
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn("formData2Dic:param decode failed...", (Throwable)e);
                }
            }
        });
        return result;
    }

    public static String addressToString(List<InetSocketAddress> clients) {
        if (clients.isEmpty()) {
            return "no session had been closed";
        }
        StringBuilder sb = new StringBuilder();
        for (InetSocketAddress addr : clients) {
            sb.append(addr).append("|");
        }
        return sb.toString();
    }

    public static String parsePostBody(HttpExchange exchange) throws IOException {
        StringBuilder body = new StringBuilder();
        if (HttpMethod.POST.name().equalsIgnoreCase(exchange.getRequestMethod()) || HttpMethod.PUT.name().equalsIgnoreCase(exchange.getRequestMethod())) {
            try (InputStreamReader reader = new InputStreamReader(exchange.getRequestBody(), Consts.UTF_8);){
                int read;
                char[] buffer = new char[256];
                while ((read = reader.read(buffer)) != -1) {
                    body.append(buffer, 0, read);
                }
            }
        }
        return body.toString();
    }

    public static void sendSuccessResponseHeaders(HttpExchange httpExchange) throws IOException {
        httpExchange.sendResponseHeaders(200, 0L);
    }
}

