/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.api.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationWrapper.class);
    private static final String EVENTMESH_CONFIG_HOME = System.getProperty("confPath", System.getenv("confPath"));

    public static Properties getConfig(String configFile) throws IOException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(configFile);
        String configFilePath = resource != null && new File(resource.getPath()).exists() ? resource.getPath() : EVENTMESH_CONFIG_HOME + File.separator + configFile;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("loading auth config: {}", (Object)configFilePath);
        }
        Properties properties = new Properties();
        try (BufferedReader br = new BufferedReader(new FileReader(configFilePath));){
            properties.load(br);
        }
        return properties;
    }
}

