/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.redisson.RedissonMap;
import org.redisson.RedissonObject;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.Hash;
import org.redisson.misc.HashValue;
import org.redisson.transaction.BaseTransactionalObject;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.DeleteOperation;
import org.redisson.transaction.operation.TouchOperation;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.UnlinkOperation;
import org.redisson.transaction.operation.map.MapAddAndGetOperation;
import org.redisson.transaction.operation.map.MapFastPutIfAbsentOperation;
import org.redisson.transaction.operation.map.MapFastPutIfExistsOperation;
import org.redisson.transaction.operation.map.MapFastPutOperation;
import org.redisson.transaction.operation.map.MapFastRemoveOperation;
import org.redisson.transaction.operation.map.MapOperation;
import org.redisson.transaction.operation.map.MapPutIfAbsentOperation;
import org.redisson.transaction.operation.map.MapPutIfExistsOperation;
import org.redisson.transaction.operation.map.MapPutOperation;
import org.redisson.transaction.operation.map.MapRemoveOperation;
import org.redisson.transaction.operation.map.MapReplaceOperation;

public class BaseTransactionalMap<K, V>
extends BaseTransactionalObject {
    private final long timeout;
    final List<TransactionalOperation> operations;
    final Map<HashValue, MapEntry> state = new HashMap<HashValue, MapEntry>();
    final RMap<K, V> map;
    final CommandAsyncExecutor commandExecutor;
    final String transactionId;
    Boolean deleted;

    public BaseTransactionalMap(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, RMap<K, V> map, String transactionId) {
        this.timeout = timeout;
        this.operations = operations;
        this.map = map;
        this.commandExecutor = commandExecutor;
        this.transactionId = transactionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashValue toKeyHash(Object key) {
        ByteBuf keyState = ((RedissonObject)((Object)this.map)).encodeMapKey(key);
        try {
            HashValue hashValue = new HashValue(Hash.hash128(keyState));
            return hashValue;
        }
        finally {
            keyState.release();
        }
    }

    public RFuture<Boolean> isExistsAsync() {
        if (this.deleted != null) {
            return new CompletableFutureWrapper<Boolean>(this.deleted == false);
        }
        return this.map.isExistsAsync();
    }

    public RFuture<Boolean> unlinkAsync(CommandAsyncExecutor commandExecutor) {
        return this.deleteAsync(commandExecutor, new UnlinkOperation(this.map.getName()));
    }

    public RFuture<Boolean> touchAsync(CommandAsyncExecutor commandExecutor) {
        if (this.deleted != null && this.deleted.booleanValue()) {
            this.operations.add(new TouchOperation(this.map.getName()));
            return new CompletableFutureWrapper<Boolean>(false);
        }
        CompletionStage<Boolean> f = this.map.isExistsAsync().thenApply(exists -> {
            this.operations.add(new TouchOperation(this.map.getName()));
            if (!exists.booleanValue()) {
                for (MapEntry entry : this.state.values()) {
                    if (entry == MapEntry.NULL) continue;
                    exists = true;
                    break;
                }
            }
            return exists;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    public RFuture<Boolean> deleteAsync(CommandAsyncExecutor commandExecutor) {
        return this.deleteAsync(commandExecutor, new DeleteOperation(this.map.getName()));
    }

    protected RFuture<Boolean> deleteAsync(CommandAsyncExecutor commandExecutor, TransactionalOperation operation) {
        if (this.deleted != null) {
            this.operations.add(operation);
            CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
            result.complete(this.deleted == false);
            this.deleted = true;
            return new CompletableFutureWrapper<Boolean>(result);
        }
        CompletionStage<Boolean> f = this.map.isExistsAsync().thenApply(res -> {
            this.operations.add(operation);
            this.state.replaceAll((k, v) -> MapEntry.NULL);
            this.deleted = true;
            return res;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    protected ScanResult<Map.Entry<Object, Object>> scanIterator(String name, RedisClient client, long startPos, String pattern, int count) {
        ScanResult<Map.Entry<Object, Object>> res = ((RedissonMap)this.map).scanIterator(name, client, startPos, pattern, count);
        HashMap<HashValue, MapEntry> newstate = new HashMap<HashValue, MapEntry>(this.state);
        HashMap<Object, Object> newres = null;
        Iterator<Map.Entry<Object, Object>> iterator = res.getValues().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            MapEntry mapEntry = (MapEntry)newstate.remove(this.toKeyHash(entry.getKey()));
            if (mapEntry == null) continue;
            if (mapEntry == MapEntry.NULL) {
                iterator.remove();
                continue;
            }
            if (newres == null) {
                newres = new HashMap<Object, Object>();
                for (Map.Entry<Object, Object> e : res.getValues()) {
                    newres.put(e.getKey(), e.getValue());
                }
            }
            newres.put(entry.getKey(), mapEntry.getValue());
        }
        if (startPos == 0L) {
            for (Map.Entry entry : newstate.entrySet()) {
                if (entry.getValue() == MapEntry.NULL) continue;
                if (newres == null) {
                    newres = new HashMap();
                    for (Map.Entry<Object, Object> e : res.getValues()) {
                        newres.put(e.getKey(), e.getValue());
                    }
                }
                newres.put(((MapEntry)entry.getValue()).getKey(), ((MapEntry)entry.getValue()).getValue());
            }
        }
        if (newres != null) {
            return new MapScanResult<Object, Object>(res.getPos(), newres);
        }
        return res;
    }

    public RFuture<Boolean> containsKeyAsync(Object key) {
        HashValue keyHash = this.toKeyHash(key);
        MapEntry currentValue = this.state.get(keyHash);
        if (currentValue != null) {
            if (currentValue == MapEntry.NULL) {
                return new CompletableFutureWrapper<Boolean>(false);
            }
            return new CompletableFutureWrapper<Boolean>(true);
        }
        return this.map.containsKeyAsync(key);
    }

    public RFuture<Boolean> containsValueAsync(Object value) {
        for (MapEntry entry : this.state.values()) {
            if (entry == MapEntry.NULL || !this.isEqual(entry.getValue(), value)) continue;
            return new CompletableFutureWrapper<Boolean>(true);
        }
        return this.map.containsValueAsync(value);
    }

    protected RFuture<V> addAndGetOperationAsync(K key, Number value) {
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                BigDecimal currentValue = BigDecimal.ZERO;
                if (entry != MapEntry.NULL) {
                    currentValue = (BigDecimal)entry.getValue();
                }
                BigDecimal res = currentValue.add(new BigDecimal(value.toString()));
                this.operations.add(new MapAddAndGetOperation(this.map, key, value, this.transactionId, threadId));
                this.state.put(keyHash, new MapEntry(key, res));
                if (this.deleted != null) {
                    this.deleted = false;
                }
                NumberConvertor convertor = new NumberConvertor(value.getClass());
                return CompletableFuture.completedFuture(convertor.convert(res.toPlainString()));
            }
            return this.map.getAsync(key).thenApply(r -> {
                BigDecimal currentValue = new BigDecimal(r.toString());
                BigDecimal res = currentValue.add(new BigDecimal(value.toString()));
                this.operations.add(new MapAddAndGetOperation(this.map, key, value, this.transactionId, threadId));
                this.state.put(keyHash, new MapEntry(key, res));
                if (this.deleted != null) {
                    this.deleted = false;
                }
                NumberConvertor convertor = new NumberConvertor(value.getClass());
                return convertor.convert(res.toPlainString());
            });
        });
    }

    protected RFuture<V> putIfExistsOperationAsync(K key, V value) {
        long threadId = Thread.currentThread().getId();
        return this.putIfExistsOperationAsync(key, value, new MapPutIfExistsOperation(this.map, key, value, this.transactionId, threadId));
    }

    protected RFuture<V> putIfExistsOperationAsync(K key, V value, MapOperation mapOperation) {
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                this.operations.add(mapOperation);
                if (entry != MapEntry.NULL) {
                    this.state.put(keyHash, new MapEntry(key, value));
                    if (this.deleted != null) {
                        this.deleted = false;
                    }
                    return CompletableFuture.completedFuture(entry.getValue());
                }
                return CompletableFuture.completedFuture(null);
            }
            return this.map.getAsync(key).thenApply(res -> {
                this.operations.add(mapOperation);
                if (res != null) {
                    this.state.put(keyHash, new MapEntry(key, value));
                    if (this.deleted != null) {
                        this.deleted = false;
                    }
                }
                return res;
            });
        });
    }

    protected RFuture<V> putIfAbsentOperationAsync(K key, V value) {
        long threadId = Thread.currentThread().getId();
        return this.putIfAbsentOperationAsync(key, value, new MapPutIfAbsentOperation(this.map, key, value, this.transactionId, threadId));
    }

    protected RFuture<V> putIfAbsentOperationAsync(K key, V value, MapOperation mapOperation) {
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                this.operations.add(mapOperation);
                if (entry == MapEntry.NULL) {
                    this.state.put(keyHash, new MapEntry(key, value));
                    if (this.deleted != null) {
                        this.deleted = false;
                    }
                    return CompletableFuture.completedFuture(null);
                }
                return CompletableFuture.completedFuture(entry.getValue());
            }
            return this.map.getAsync(key).thenApply(res -> {
                this.operations.add(mapOperation);
                if (res == null) {
                    this.state.put(keyHash, new MapEntry(key, value));
                    if (this.deleted != null) {
                        this.deleted = false;
                    }
                }
                return res;
            });
        });
    }

    protected final RFuture<V> putOperationAsync(K key, V value) {
        long threadId = Thread.currentThread().getId();
        return this.putOperationAsync(key, value, new MapPutOperation(this.map, key, value, this.transactionId, threadId));
    }

    protected RFuture<V> putOperationAsync(K key, V value, MapOperation operation) {
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                this.operations.add(operation);
                this.state.put(keyHash, new MapEntry(key, value));
                if (this.deleted != null) {
                    this.deleted = false;
                }
                if (entry == MapEntry.NULL) {
                    return CompletableFuture.completedFuture(null);
                }
                return CompletableFuture.completedFuture(entry.getValue());
            }
            return this.map.getAsync(key).thenApply(res -> {
                this.operations.add(operation);
                this.state.put(keyHash, new MapEntry(key, value));
                if (this.deleted != null) {
                    this.deleted = false;
                }
                return res;
            });
        });
    }

    protected RFuture<Boolean> fastPutIfExistsOperationAsync(K key, V value) {
        long threadId = Thread.currentThread().getId();
        return this.fastPutIfExistsOperationAsync(key, value, new MapFastPutIfExistsOperation(this.map, key, value, this.transactionId, threadId));
    }

    protected RFuture<Boolean> fastPutIfExistsOperationAsync(K key, V value, MapOperation mapOperation) {
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                this.operations.add(mapOperation);
                if (entry != MapEntry.NULL) {
                    this.state.put(keyHash, new MapEntry(key, value));
                    if (this.deleted != null) {
                        this.deleted = false;
                    }
                    return CompletableFuture.completedFuture(true);
                }
                return CompletableFuture.completedFuture(false);
            }
            return this.map.getAsync(key).thenApply(res -> {
                this.operations.add(mapOperation);
                if (res != null) {
                    this.state.put(keyHash, new MapEntry(key, value));
                    if (this.deleted != null) {
                        this.deleted = false;
                    }
                }
                return true;
            });
        });
    }

    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(K key, V value) {
        long threadId = Thread.currentThread().getId();
        return this.fastPutIfAbsentOperationAsync(key, value, new MapFastPutIfAbsentOperation(this.map, key, value, this.transactionId, threadId));
    }

    protected RFuture<Boolean> fastPutIfAbsentOperationAsync(K key, V value, MapOperation mapOperation) {
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                this.operations.add(mapOperation);
                if (entry == MapEntry.NULL) {
                    this.state.put(keyHash, new MapEntry(key, value));
                    if (this.deleted != null) {
                        this.deleted = false;
                    }
                    return CompletableFuture.completedFuture(true);
                }
                return CompletableFuture.completedFuture(false);
            }
            return this.map.getAsync(key).thenApply(res -> {
                boolean isUpdated;
                this.operations.add(mapOperation);
                boolean bl = isUpdated = res == null;
                if (isUpdated) {
                    this.state.put(keyHash, new MapEntry(key, value));
                    if (this.deleted != null) {
                        this.deleted = false;
                    }
                }
                return isUpdated;
            });
        });
    }

    protected RFuture<Boolean> fastPutOperationAsync(K key, V value) {
        long threadId = Thread.currentThread().getId();
        return this.fastPutOperationAsync(key, value, new MapFastPutOperation(this.map, key, value, this.transactionId, threadId));
    }

    protected RFuture<Boolean> fastPutOperationAsync(K key, V value, MapOperation operation) {
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                this.operations.add(operation);
                this.state.put(keyHash, new MapEntry(key, value));
                if (this.deleted != null) {
                    this.deleted = false;
                }
                return CompletableFuture.completedFuture(entry == MapEntry.NULL);
            }
            return this.map.getAsync(key).thenApply(res -> {
                this.operations.add(operation);
                this.state.put(keyHash, new MapEntry(key, value));
                if (this.deleted != null) {
                    this.deleted = false;
                }
                boolean isNew = res == null;
                return isNew;
            });
        });
    }

    protected RFuture<Long> fastRemoveOperationAsync(K ... keys) {
        long threadId = Thread.currentThread().getId();
        List<RLock> locks = Arrays.stream(keys).map(k -> this.getLock(k)).collect(Collectors.toList());
        return this.executeLocked(this.timeout, () -> {
            AtomicLong counter = new AtomicLong();
            List<Object> keyList = Arrays.asList(keys);
            Iterator<Object> iterator = keyList.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                HashValue keyHash = this.toKeyHash(key);
                MapEntry currentValue = this.state.get(keyHash);
                if (currentValue == null || currentValue == MapEntry.NULL) continue;
                this.operations.add(new MapFastRemoveOperation(this.map, key, this.transactionId, threadId));
                this.state.put(keyHash, MapEntry.NULL);
                counter.incrementAndGet();
                iterator.remove();
            }
            return this.map.getAllAsync(new HashSet<Object>(keyList)).thenApply(res -> {
                for (Object key : res.keySet()) {
                    HashValue keyHash = this.toKeyHash(key);
                    this.operations.add(new MapFastRemoveOperation(this.map, key, this.transactionId, threadId));
                    counter.incrementAndGet();
                    this.state.put(keyHash, MapEntry.NULL);
                }
                return counter.get();
            });
        }, locks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RFuture<Integer> valueSizeAsync(K key) {
        HashValue keyHash = this.toKeyHash(key);
        MapEntry entry = this.state.get(keyHash);
        if (entry != null) {
            if (entry == MapEntry.NULL) {
                return new CompletableFutureWrapper<Integer>((Integer)null);
            }
            ByteBuf valueState = ((RedissonObject)((Object)this.map)).encodeMapValue(entry.getValue());
            try {
                CompletableFutureWrapper<Integer> completableFutureWrapper = new CompletableFutureWrapper<Integer>(valueState.readableBytes());
                return completableFutureWrapper;
            }
            finally {
                valueState.release();
            }
        }
        return this.map.valueSizeAsync(key);
    }

    protected RFuture<V> getOperationAsync(K key) {
        HashValue keyHash = this.toKeyHash(key);
        MapEntry entry = this.state.get(keyHash);
        if (entry != null) {
            if (entry == MapEntry.NULL) {
                return new CompletableFutureWrapper<Object>(null);
            }
            return new CompletableFutureWrapper<Object>(entry.getValue());
        }
        return ((RedissonMap)this.map).getOperationAsync(key);
    }

    public RFuture<Set<K>> readAllKeySetAsync() {
        RFuture future = this.map.readAllKeySetAsync();
        CompletionStage<Set> f = future.thenApply(res -> {
            HashMap<HashValue, MapEntry> newstate = new HashMap<HashValue, MapEntry>(this.state);
            Iterator iterator = res.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                MapEntry value = (MapEntry)newstate.remove(this.toKeyHash(key));
                if (value != MapEntry.NULL) continue;
                iterator.remove();
            }
            for (MapEntry entry : newstate.values()) {
                if (entry == MapEntry.NULL) continue;
                res.add(entry.getKey());
            }
            return res;
        });
        return new CompletableFutureWrapper<Set<K>>(f);
    }

    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        RFuture<Map<K, V>> future = this.readAllMapAsync();
        CompletionStage<Set> f = future.thenApply(res -> res.entrySet());
        return new CompletableFutureWrapper<Set<Map.Entry<K, V>>>(f);
    }

    public RFuture<Collection<V>> readAllValuesAsync() {
        RFuture<Map<K, V>> future = this.readAllMapAsync();
        CompletionStage<Collection> f = future.thenApply(res -> res.values());
        return new CompletableFutureWrapper<Collection<V>>(f);
    }

    public RFuture<Map<K, V>> readAllMapAsync() {
        RFuture future = this.map.readAllMapAsync();
        CompletionStage<Map> f = future.thenApply(map -> {
            HashMap<HashValue, MapEntry> newstate = new HashMap<HashValue, MapEntry>(this.state);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                MapEntry entry = (MapEntry)newstate.remove(this.toKeyHash(key));
                if (entry == MapEntry.NULL) {
                    iterator.remove();
                    continue;
                }
                if (entry == null) continue;
                map.put(key, entry.getValue());
            }
            for (MapEntry entry : newstate.values()) {
                if (entry == MapEntry.NULL) continue;
                map.put(entry.getKey(), entry.getValue());
            }
            return map;
        });
        return new CompletableFutureWrapper<Map<K, V>>(f);
    }

    protected RFuture<Map<K, V>> getAllOperationAsync(Set<K> keys) {
        HashSet<K> keysToLoad = new HashSet<K>();
        HashMap map = new HashMap();
        for (K key : keys) {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                if (entry == MapEntry.NULL) continue;
                map.put(key, entry.getValue());
                continue;
            }
            keysToLoad.add(key);
        }
        if (keysToLoad.isEmpty()) {
            return new CompletableFutureWrapper<Map<K, V>>(map);
        }
        RFuture future = ((RedissonMap)this.map).getAllOperationAsync(keysToLoad);
        CompletionStage<Map> f = future.thenApply(res -> {
            map.putAll((Map)res);
            return map;
        });
        return new CompletableFutureWrapper<Map<K, V>>(f);
    }

    protected RFuture<V> removeOperationAsync(K key) {
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                this.operations.add(new MapRemoveOperation(this.map, key, this.transactionId, threadId));
                if (entry == MapEntry.NULL) {
                    return CompletableFuture.completedFuture(null);
                }
                this.state.put(keyHash, MapEntry.NULL);
                return CompletableFuture.completedFuture(entry.getValue());
            }
            return this.map.getAsync(key).thenApply(res -> {
                this.operations.add(new MapRemoveOperation(this.map, key, this.transactionId, threadId));
                if (res != null) {
                    this.state.put(keyHash, MapEntry.NULL);
                }
                return res;
            });
        });
    }

    protected RFuture<Boolean> removeOperationAsync(Object key, Object value) {
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                if (entry == MapEntry.NULL) {
                    return CompletableFuture.completedFuture(false);
                }
                this.operations.add(new MapRemoveOperation(this.map, key, value, this.transactionId, threadId));
                if (this.isEqual(entry.getValue(), value)) {
                    this.state.put(keyHash, MapEntry.NULL);
                    return CompletableFuture.completedFuture(true);
                }
                return CompletableFuture.completedFuture(false);
            }
            return this.map.getAsync(key).thenApply(r -> {
                this.operations.add(new MapRemoveOperation(this.map, key, value, this.transactionId, threadId));
                boolean res = this.isEqual(r, value);
                if (res) {
                    this.state.put(keyHash, MapEntry.NULL);
                }
                return res;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEqual(Object value, Object oldValue) {
        ByteBuf valueBuf = ((RedissonObject)((Object)this.map)).encodeMapValue(value);
        ByteBuf oldValueBuf = ((RedissonObject)((Object)this.map)).encodeMapValue(oldValue);
        try {
            boolean bl = valueBuf.equals((Object)oldValueBuf);
            return bl;
        }
        finally {
            valueBuf.readableBytes();
            oldValueBuf.readableBytes();
        }
    }

    protected RFuture<Void> putAllOperationAsync(Map<? extends K, ? extends V> entries) {
        long threadId = Thread.currentThread().getId();
        List<RLock> list = entries.keySet().stream().map(k -> this.getLock(k)).collect(Collectors.toList());
        return this.executeLocked(this.timeout, () -> {
            for (Map.Entry entry : entries.entrySet()) {
                this.operations.add(new MapPutOperation(this.map, entry.getKey(), entry.getValue(), this.transactionId, threadId));
                HashValue keyHash = this.toKeyHash(entry.getKey());
                this.state.put(keyHash, new MapEntry(entry.getKey(), entry.getValue()));
            }
            if (this.deleted != null) {
                this.deleted = false;
            }
            return CompletableFuture.completedFuture(null);
        }, list);
    }

    protected RFuture<Boolean> replaceOperationAsync(K key, V oldValue, V newValue) {
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            if (entry != null) {
                if (entry == MapEntry.NULL) {
                    return CompletableFuture.completedFuture(false);
                }
                this.operations.add(new MapReplaceOperation(this.map, key, newValue, oldValue, this.transactionId, threadId));
                if (this.isEqual(entry.getValue(), oldValue)) {
                    this.state.put(keyHash, new MapEntry(key, newValue));
                    return CompletableFuture.completedFuture(true);
                }
                return CompletableFuture.completedFuture(false);
            }
            return this.map.getAsync(key).thenApply(r -> {
                this.operations.add(new MapReplaceOperation(this.map, key, newValue, oldValue, this.transactionId, threadId));
                boolean res = this.isEqual(r, oldValue);
                if (res) {
                    this.state.put(keyHash, new MapEntry(key, newValue));
                }
                return res;
            });
        });
    }

    protected RFuture<V> replaceOperationAsync(K key, V value) {
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(key, () -> {
            HashValue keyHash = this.toKeyHash(key);
            MapEntry entry = this.state.get(keyHash);
            this.operations.add(new MapReplaceOperation(this.map, key, value, this.transactionId, threadId));
            if (entry != null) {
                if (entry == MapEntry.NULL) {
                    return CompletableFuture.completedFuture(null);
                }
                this.state.put(keyHash, new MapEntry(key, value));
                return CompletableFuture.completedFuture(entry.getValue());
            }
            return this.map.getAsync(key).thenApply(res -> {
                this.operations.add(new MapReplaceOperation(this.map, key, value, this.transactionId, threadId));
                if (res != null) {
                    this.state.put(keyHash, new MapEntry(key, value));
                }
                return res;
            });
        });
    }

    protected <R> RFuture<R> executeLocked(K key, Supplier<CompletionStage<R>> runnable) {
        RLock lock = this.getLock(key);
        return this.executeLocked(this.timeout, runnable, lock);
    }

    protected RLock getLock(K key) {
        String lockName = ((RedissonMap)this.map).getLockByMapKey(key, "lock");
        return new RedissonTransactionalLock(this.commandExecutor, lockName, this.transactionId);
    }

    public static class MapEntry {
        public static final MapEntry NULL = new MapEntry(null, null);
        private final Object key;
        private final Object value;

        public MapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

